package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SxclmlVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.WycclxxVo;

import java.util.List;

/**
 * <p>
 * 网约车车辆申请 服务类
 * </p>
 *
 * @author ln
 * @since 2020-05-21
 */
public interface WycclxxService {

    /**
     * 分页查询
     *
     * @param page 当前页
     * @param rows 每页显示条数
     * @param wycclxxVo
     * @return
     */

    Page<WycclxxVo> page(WycclxxVo wycclxxVo, long page, long rows);

    /**
     * 修改网约车车辆申请信息
     *
     * @param wycclxxVo
     * @return
     */
    boolean updateById(WycclxxVo wycclxxVo);

    /**
     * 根据ID删除网约车车辆申请信息
     *
     * @param id　网约车车辆申请ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取网约车车辆申请信息
     *
     * @param id
     * @return
     */
    WycclxxVo getById(String id);

    /**
     * 查询相关的事项材料目录
     * @param wycclxxVo 实施事项id
     * @return
     */
    List<SxclmlVo> findSxclmlInfo(WycclxxVo wycclxxVo);
}

