package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqtxlxxxVo;

import java.util.List;

/**
 * <p>
 *  申请通行路线信息 服务类
 * </p>
 *
 * @author ln
 * @since 2020-06-05
 */
public interface SqtxlxxxService {

    /**
     * 新增信息
     *
     * @param sqtxlxxxVo
     * @return
     */
    boolean insert(SqtxlxxxVo sqtxlxxxVo);

    /**
     * 修改信息
     *
     * @param sqtxlxxxVo
     * @return
     */
    boolean updateById(SqtxlxxxVo sqtxlxxxVo);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    SqtxlxxxVo getById(String id);

    /**
     * 根据申请信息Id获取对应路线信息(省内路线包含起点、终点)
     * @param sqxxId 申请信息Id
     * @return
     */
    List<SqtxlxxxVo> getBySqxxId(String sqxxId);

    /**
     * 根据申请信息Id获取对应路线信息(省内路线不包含起点、终点)
     * @param sqxxId 申请信息Id
     * @return
     */
    List<SqtxlxxxVo> getLXBySqxxId(String sqxxId);
}

