package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DaiBanVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspJSpjlVO;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;

import java.util.List;

/**
 * <p>
 * 行政审批-我的在办页面（超限案件-批量交警回复、打证页面） 服务类
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-06-29
 */
public interface MyZaiBanService {
    /**
     * 我的待办列表分页查询
     * @param page 分页信息
     * @param daiBanVO 查询参数
     * @return
     */
    IPage<DaiBanVO> page(IPage<DaiBanVO> page, DaiBanVO daiBanVO);

    /**
     * 批量处理-分发环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @param zdjgid 指定机构ID
     * @param zdjg 指定机构名称
     * @return
     */
    boolean executeFlowFFList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SysUser curUser, String zdjgid, String zdjg);

    /**
     * 批量交警回复
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    JsonResult batchJJReply(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SqxxVo sqxxVo, SysUser curUser);

    /**
     * 批量同意打证
     * @param paramData 参数数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    boolean batchPrintCert(String paramData, XzspJSpjlVO spjlVO, SysUser curUser);

    /**
     * 批量处理-通用环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    boolean executeFlowList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SysUser curUser);

    /**
     * 批量处理-受理环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    boolean executeFlowSLList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SysUser curUser);

    /**
     * 批量处理-复审环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    boolean executeFlowFSList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SysUser curUser);

    /**
     * 批量处理-终审环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    JsonResult executeFlowZSList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO,SqxxVo sqxxVo, SysUser curUser);

    /**
     * 批量处理-审批决定环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    boolean executeFlowSPJDList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SysUser curUser);

    /**
     * 批量处理-许可、不予许可环节
     * @param sqxxList 申请信息列表数据
     * @param spjlVO 审批记录信息
     * @param sqxxVo 申请信息数据
     * @param curUser 当前用户数据
     * @return
     */
    boolean executeFlowJDList(List<SqxxVo> sqxxList, XzspJSpjlVO spjlVO, SqxxVo sqxxVo, SysUser curUser);

    /**
     * 批量处理-送达环节
     * @param sqxxList 申请信息列表数据
     * @param sdInfoJson 送达信息Json数据
     * @param spjlVO 审批记录信息
     * @param curUser 当前用户数据
     * @return
     */
    boolean executeFlowSDList(List<SqxxVo> sqxxList, String sdInfoJson, XzspJSpjlVO spjlVO, SysUser curUser);
}
