package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.flows.entity.WfActivityinst;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DaiBanVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.FzclVo;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;

import java.util.List;

public interface MyYiBanService {

    /**
     * 我的已办列表分页查询
     * @param page 分页信息
     * @param daiBanVO 查询参数
     * @return
     */
     IPage<DaiBanVO> page(IPage page, DaiBanVO daiBanVO);

    /**
     * 得到当前环节剩余时限
     * @param sqxxid
     * @return
     */
    String getHjsysxBySqxxid(String sqxxid);

    /**
     * 根据环节时限单位和环节时限获取分钟数
     * @param sxdwdm
     * @param hjsx
     * @return
     */
    int getCount(String sxdwdm, int hjsx);

    /**
     * 得到流程历史记录
     * @param sqxxid
     * @param actclasses
     * @return
     */
     List<WfActivityinst> getHistoryHJ(String sqxxid, String[] actclasses);

    /**
     * 检测办件是否可以勘验
     * @param sqxxid 申请信息ID
     * @param curUser 当前用户
     * @return
     */
    JsonResult checkKyclZt(String sqxxid, SysUser curUser);

    /**
     * update勘验处理状态
     * @param sqxxid
     * @param kycl
     * @return
     */
     boolean changeKyclZt(String sqxxid,String kycl, SysUser sysUser) throws Exception;

    /**
     * 材料绑定到事件上
     * @param sqxxid
     * @param fileKey
     * @return
     */
     int savaFZorKYWS(String sqxxid,String fileKey,String wslx);

    /**
     * 材料绑定到事件上
     * @param sqxxid
     * @param fileKey
     * @return
     */
     int savaKYWS(String sqxxid,String fileKey);

    /**
     * 得到辅助材料对应事件的材料的key和名称
     * @param sqxxid
     * @return
     */
     List<FzclVo> findWsxx(String sqxxid);

    /**
     * 得到勘验材料对应事件的材料的key和名称
     * @param sqxxid
     * @return
     */
     List<FzclVo> findKyOrPtWsxx(String sqxxid,String fjlx);

}
