package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.*;
import com.kdgcsoft.rdc.document.service.helper.JsonMsg;
import com.kdgcsoft.rdc.document.service.vo.PageRequestParam;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 行政审批-我的待办 服务类
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-05-1
 */
public interface MyDaiBanService {

    /**
     * 我的待办列表分页查询
     * @param page 分页信息
     * @param daiBanVO 查询参数
     * @return
     */
    IPage<DaiBanVO> page(IPage page, DaiBanVO daiBanVO);

    /**
     * 根据环节时限单位和环节时限获取分钟数
     * @param sxdwdm  时限单位代码
     * @param hjsx    环节时限
     * @return
     */
    int getCount(String sxdwdm, int hjsx);

    /**
     * 查看最新的环节状态
     * @param requestParam 工作流id、环节状态信息
     * @return boolean
     */
    boolean findLastHjxx(Requestparam requestParam);

    /**
     * 获取当前用户历史许可申请受理通知书联系人信息
     *  @param curUser 当前用户信息
     * @return
     */
    HashMap<String,String> getHisSLTZSLXR(SysUser curUser);

    /**
     * 获取当前用户历史文书送达回证送达地址信息
     *
     * @param curUser 当前用户信息
     * @return
     */
    String getHisWSSDHZDZ(SysUser curUser);

    /**
     * 案件流转到下一步工作流(通用)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlow(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(分发环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowFF(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(受理环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowSL(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(跨省大件超限-受理环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowCXSL(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(初审环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowCS(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(复审环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowFS(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(终审环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowZS(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(超限交警审核环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowJJSH(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(协调路线环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowXTLX(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(审批决定环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流参数
     * @param curUser 当前用户
     * @return
     */
    boolean executeFlowSPJD(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam, SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(制作决定书环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流信息
     * @return
     */
    boolean executeFlowJD(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam,SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(批复环节)
     * @param spjlVO 审批记录数据
     * @param sqxxVo 申请信息数据
     * @param requestParam 工作流信息
     * @return
     */
    boolean executeFlowPF(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, PageRequestParam requestParam,SysUser curUser) throws Exception;

    /**
     * 案件流转到下一步工作流(送达环节)
     * @param spjlVO 审批记录数据
     * @param sdInfoJson 送达信息Json数据
     * @param requestParam 工作流参数
     * @return
     */
    boolean executeFlowSD(XzspJSpjlVO spjlVO, String sdInfoJson, PageRequestParam requestParam,SysUser curUser) throws Exception;

    /**
     * 页面预览决定书
     * @param spjlVO 决定书信息
     * @param sqxxVo 申请信息
     * @param curUser 用户信息
     * @return
     */
    PageRequestParam yulanJDSPdf(XzspJSpjlVO spjlVO, SqxxVo sqxxVo, SysUser curUser) throws Exception;

    /**
     * 获取页面预览决定书
     * @param valueId 决定书信息valueId
     * @return pdf字节流
     */
    byte[] getJDSPdf(String valueId);

    /**
     * 删除页面预览决定书
     * @param spjlVO 决定书信息
     * @param sqxxVo 申请信息
     * @return
     */
     void deleteJDSPdf(XzspJSpjlVO spjlVO, SqxxVo sqxxVo);


    /**
     * 生成通行证
     * @throws IllegalAccessException
     * @throws IllegalArgumentException
     */
    JsonMsg executeFlowTxz(SqcltxzVo form, PageRequestParam requestParam,SysUser curUser) throws Exception;

    /**
     * 获取通行证数据生成通行证-自动生成文书
     * @param dbSqxxVo 申请信息
     * @param requestParam 工作流信息
     * @param spjlVO 审批信息
     * @return
     * @throws Exception
     */
    JsonMsg executeCXPZ(SqxxVo dbSqxxVo, PageRequestParam requestParam, XzspJSpjlVO spjlVO,SysUser curUser) throws Exception;

    /**
     * 获取申请材料list
     * @param eventId
     * @return
     */
    List<JsclVO> getJsclList(String eventId);

    /**
     * 查看人员是否具备按钮权限
     * @param user
     * @return
     */
	List<DaiBanVO> butSwitch(SysUser user);
	
	/**
	 * 查询通行证
	 * @param form
	 * @return
	 */
	List<SqcltxzVo> exportExcelTxz(DaiBanVO form);

    /**
     * 查询文书是否生成pdf
     * @param valueId
     * @return
     */
    String searchDoIstx(String valueId);

    /**
     * 重新分发
     * @param sqxxVo 申请信息
     * @param curUser 用户信息
     * @return
     */
    boolean submitRedistribute(SqxxVo sqxxVo, SysUser curUser);

    /**
     * 更新申请信息
     * @param sqxxVo 申请信息
     * @return
     */
    boolean saveSqxx(SqxxVo sqxxVo);

    /**
     * 查找申请信息的决定书类型
     * @param eventId 申请信息id
     * @return
     */
    String searchJdsType(String eventId);

    /**
     * 查找勘验情况报告通行路线
     * @param sqxxid 申请信息id
     * @return
     */
    String getXglx(String sqxxid);
}
