package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import java.util.List;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SssxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SxxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.shouYe.EchartsVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.BjtjVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.BjyjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DaiBanVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.bjsztjVo;

public interface HomeService {

	/**
	 * 个人办件top5
	 * @param sssxid
	 * @param user
	 * @return
	 */
	List<SssxVo> bjTop5(String sssxid, SysUser user);

	/**
	 * 事项统计
	 * @param type 
	 * @param user
	 * @return
	 */
	List<SxxxVo> sxtj(SxxxVo form, SysUser user);

	/**
	 * 事项统计列表
	 * @param page
	 * @param user
	 * @param rows
	 * @param form
	 * @return
	 */
	Page<DaiBanVO> sxtjPage(long page, SysUser user, long rows, SxxxVo form);

	/**
	 * 单位/个人办件统计
	 * @param form 
	 * @param type 
	 * @param user
	 * @return
	 */
	List<SssxVo> bjtj(SssxVo form, SysUser user);

	/**
	 * 单位/个人办件统计列表
	 * @param page
	 * @param user
	 * @param rows
	 * @param form
	 * @return
	 */
	Page<DaiBanVO> bjtjPage(long page, SysUser user, long rows, SssxVo form);

	/**
	 * 快捷入口6项-我的待办统计
	 * @param user
	 * @return
	 */
	long kjrkDBNum(SysUser user);

	/**
	 * 快捷入口6项-未配置人员预警统计
	 * @param user
	 * @return
	 */
	long kjrkWPZRYNum(SysUser user);

	/**
	 * 快捷入口6项-我的待勘验统计
	 * @param user
	 * @return
	 */
	long kjrkDKYNum(SysUser user);

	/**
	 * 快捷入口6项-超限征询函统计
	 * @param user
	 * @return
	 */
	long kjrkCXZXHNum(SysUser user);

	/**
	 * 快捷入口6项-运管征询函统计
	 * @param user
	 * @return
	 */
	long kjrkYGZXHNum(SysUser user);

	/**
	 * 快捷入口6项-跨省车辆变更统计
	 * @param user
	 * @return
	 */
	long kjrkKSCLBGNum(SysUser user);

    /**
     * 办件预警-统计
     * @param xzspJBjyjxx
     * @return
     */
    List<EchartsVO> syYjtj(BjyjxxVO xzspJBjyjxx);

    /**
     * 首页预警信息
     * @param sysUser 当前用户信息
     * @return
     */
    List<BjyjxxVO> syYjxx(SysUser sysUser);
    
    /**
     * 首页办件统计
     * @param user
     * @return
     */
    List<BjtjVO> sqxxtj(BjtjVO form, SysUser user);
    
    /**
     * 首页办件统计下钻
     * @param page
     * @param rows
     * @param form
     * @param user
     * @return
     */
    Page<DaiBanVO> sqxxtjPage(long page, long rows, BjtjVO form, SysUser user);

}
