package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;


import com.kdgcsoft.jt.xzzf.dubbo.xzsp.govAffairs.entity.ResultBO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.govAffairs.entity.ZwfwsbjlVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspJSpjlVO;

/**
 * 行政审批-调取政务服务平台接口
 */
 public interface GovService {
    /**
     * 申报取号
     * @param sqxxVo 申请信息
     */
    ResultBO apasRegInfo(SqxxVo sqxxVo) throws Exception;

    /**
    * 事项受理
    * @param spjlVO 审批信息
    */
    ResultBO accept(XzspJSpjlVO spjlVO) throws Exception;

    /**
     * 事项受理
     * @param zwfwsbjlVO 审批信息
     */
    ResultBO accept(ZwfwsbjlVO zwfwsbjlVO);

    /**
     * 补齐补正告知
     * @param spjlVO 审批信息
     */
    ResultBO patch(XzspJSpjlVO spjlVO) throws Exception;

    /**
     * 办理
     * @param spjlVO 审批信息
     */
    ResultBO node(XzspJSpjlVO spjlVO) throws Exception;

    /**
     * 办理
     * @param zwfwsbjlVO 审批信息
     */
    ResultBO node(ZwfwsbjlVO zwfwsbjlVO);

    /**
     * 挂起
     * @param spjlVO 审批信息
     */
    ResultBO hang(XzspJSpjlVO spjlVO) throws Exception;

    /**
     * 挂起
     * @param zwfwsbjlVO 审批信息
     */
    ResultBO hang(ZwfwsbjlVO zwfwsbjlVO);

    /**
     * 解挂
     * @param spjlVO 审批信息
     */
    ResultBO hangRelease(XzspJSpjlVO spjlVO) throws Exception;

    /**
     * 解挂
     * @param zwfwsbjlVO 审批信息
     */
    ResultBO hangRelease(ZwfwsbjlVO zwfwsbjlVO);

    /**
     * 办结
     * @param spjlVO 审批信息
     */
    ResultBO transact(XzspJSpjlVO spjlVO) throws Exception;

    /**
     * 办结
     * @param zwfwsbjlVO 审批信息
     */
    ResultBO transact(ZwfwsbjlVO zwfwsbjlVO);
}
