package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DxrzVO;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author SL
 * @since 2021-05-17
 */
public interface DxrzService {

    /**
     * 短信日志分页
     * @param page
     * @param rows
     * @param sqxxid
     * @return
     */
    Page<DxrzVO> dxrzPage(long page, long rows, String sqxxid);

    /**
     * 短信日志查询
     * @param dxrzid
     * @return
     */
    DxrzVO getDxrzById(String dxrzid);

    /**
     * 发送信息
     * @param receivers
     * @param msgSmsContent
     * @param dxrzid
     * @param jsr
     * @return
     */
    boolean sendAndSaveDxrz(String receivers, String msgSmsContent, String dxrzid, DxrzVO dxrzVO, String jsr);

    /**
     * 发送信息
     * @param receivers
     * @param msgSmsContent
     * @param curUser
     * @param mbmc
     * @param sqxxid
     * @return
     */
    boolean sendAndSave(String receivers, String msgSmsContent, String sqxxid, SysUser curUser,String mbmc);
    /**
     * 批量发送信息
     * @param receivers
     * @param msgSmsContent
     * @param curUser
     * @param mbmc
     * @param sqxxid
     * @return
     */
    boolean threadSendAndSave(List<String> receivers, String msgSmsContent, String sqxxid, SysUser curUser, String mbmc);
}
