package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SxclmlVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqDraftVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.WycclxxVo;

import java.util.List;

/**
 * <p>
 * 超限页面草稿信息 服务类
 * </p>
 *
 * @author ln
 * @since 2020-05-21
 */
public interface DraftService {

    /**
     * 分页查询我的草稿模板
     * @param page 当前页
     * @param rows 每页显示条数
     * @param sqDraftVo
     * @return
     */
    Page<SqDraftVo> page(SqDraftVo sqDraftVo, long page, long rows);

    /**
     * 获取我的草稿模板
     * @param sqdraftid 申请草稿id
     * @return SqDraftVo 草稿模板信息
     */
    SqDraftVo getMyDraft(String sqdraftid);

    /**
     * 保存草稿模板
     * @param sqDraftVo 草稿模板信息
     * @return boolean true 保存成功 false 保存失败
     */
    boolean saveDraftInfo(SqDraftVo sqDraftVo, SysUser sysUser);

    /**
     * 删除模板
     * @param sqdraftids 申请模板id
     * @return boolean
     */
    boolean delDraftById(String sqdraftids, SysUser sysUser);
}

