package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.WsxgjlVo;
import com.kdgcsoft.rdc.document.service.vo.DocumentValueHisEntity;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;

import java.util.Map;

/**
 * 文书修改服务接口类
 *
 * @author huangchao
 * @date 2021/11/24
 */
public interface DocumentModifyService {
    /**
     * 文书修改申请--分页查询
     *
     * @param page     当前页
     * @param rows     分页条数
     * @param wsxgjlVo
     * @return
     */
    IPage<WsxgjlVo> wsxgjlPage(long page, long rows, WsxgjlVo wsxgjlVo);

    /**
     * 提交文书的申请修改
     *
     * @param valueId 文书主键id
     * @return
     */
    JsonResult preSubmitModifyApply(String valueId);

    /**
     * 完善文书的修改申请信息
     *
     * @param user    当前用户
     * @param valueId 文书主键id
     * @param wsName  文书名称
     * @param opinion 申请原因
     * @return
     */
    JsonResult submitApplyMsg(SysUser user, String valueId, String wsName,String opinion);

    /**
     * 填充文书审批页面所需的参数
     *
     * @param valueId     文书主键id
     * @param locationUrl 访问地址
     */
    Map<String, Object> fillChangePageParams(String valueId, String locationUrl);

    /**
     * 提交文书修改申请的审批结果
     *
     * @param valueId 文书主键id
     * @param isAllow 是否同意申请
     * @param curUser 当前用户
     * @return
     */
    JsonResult submitApplyHandle(String valueId, String isAllow, SysUser curUser);

    /**
     * 获取文书历史记录
     *
     * @param valueHisId 文书历史记录id
     * @return
     */
    DocumentValueHisEntity getDocumentHisVo(String valueHisId);
}
