package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqcltxzVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XxztxVo;

import java.util.List;

/**
 * 事项申请信息
 * @author Nier
 *
 */
public interface CpzglService{

	/**
	 * 获取超限凭证列表-PC端
	 * @param page 页数
	 * @param rows 每页行数
	 * @param form 查询参数
	 * @return
	 */
	Page<SqcltxzVo> clbgPage(long page, long rows, SqcltxzVo form);

	/**
	 * 获取超限信息列表-APP端
	 * @param page 页数
	 * @param rows 每页行数
	 * @param form 查询参数
	 * @return
	 */
	Page<SqcltxzVo> cxxxPage(long page, long rows, SqcltxzVo form);

	/**
	 * 生成通行证前先删除通行证
	 * @param eventid
	 */
	void deleteByEventid(String eventid);

	/**
	 * 获取通过二维码扫描通行信息
	 * @param eventid
	 * @return 
	 */
	SqcltxzVo selectSqcltxz(String eventid);

	/**
	 * 提交通行次数
	 * @param from
	 * @return
	 */
	String submitTxcs(SqcltxzVo from, SysUser user);

	/**
	 * 获取通行记录
	 * @param eventid
	 * @return
	 */
	List<XxztxVo> selectXxztx(String eventid);

	/**
	 * 提交撤销
	 *
	 * @param eventid
	 * @param cxly
	 * @return
	 */
	boolean cancel(String eventid, String cxly);

	/**
	 * 查看撤销
	 *
	 * @param eventid
	 * @return
	 */
	SqcltxzVo selectById(String eventid);
}
