package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SxclmlVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 办件查询相关业务
 *
 * @author flm
 * @since 2020-05-11
 */
public interface ChaXunService {

    //初始化奖惩信息
    CreditCheckVO initJcxx(String sqxxid);

    /**
     * 根据申请人名称及证件号获取已办结的许可申请信息
     *
     * @param page   当前页
     * @param rows   分页数
     * @param sqxxVo 申请信息
     * @return Page<SqxxVo>
     */
    Page<SqxxVo> getSqxxBySqr(Long page, Long rows, SqxxVo sqxxVo);

    //跳转到查看案件信息的过渡方法
    Map<String, Object> transition(Requestparam requestparam, String buttonTemplate, String spyjTemplate, SysUser sysUser);

    /**
     * 讯飞跳转办理页面-查看办件信息
     *
     * @param bjbm         办件编码
     * @param requestparam 办件信息
     * @return
     */
    Map<String, Object> transitionXF(String bjbm, Requestparam requestparam);

    //根据id获得事件信息
    SqxxVo getInitJcxx(String sqxxid);

    //案件是否是本单位的
    boolean ifDqdw(String sqxxid, String orgId);

    //案件是否已注销
    boolean ifYzx(String sqxxid);

    //执行申请注销
    int zxsqZx(String sqxxid, String ah, String zxyy, String sxssjgid, SysUser sysUser);

    /**
     * 获取当前环节信息
     *
     * @param activityInstId 当前环节ID
     * @param sssxid         实施事项ID
     * @return
     */
    HashMap<String, Object> getCurrentHJInfo(String activityInstId, String sssxid);

    /**
     * 获取申请信息关联的材料信息
     *
     * @param sqxxid 申请信息Id
     * @return List<SxclmlVo> 材料列表信息
     */
    List<SxclmlVo> findSqclById(String sqxxid);

    /**
     * 获取初始化案件业务表单的数据
     *
     * @param sqxxid 申请信息Id
     * @param ajlydm 案件来源代码
     * @return
     */
    SqcxxxVo getInitYwbd(String sqxxid, String ajlydm);

    /**
     * 验证是否已经受理
     *
     * @param sqxxid 申请信息id
     * @return 结果
     */
    boolean checkSFSL(String sqxxid);

    /**
     * 获取办件经营范围
     *
     * @param sqxxid 申请信息id
     * @return 结果
     */
    String getJYFWString(String sqxxid);


    /**
     * 重点超限案件监管--分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sqxxVo  查询参数
     * @return
     */
    Page<SqxxVo> zdcxajPage(long current, long size, SqxxVo sqxxVo);

    /**
     * 根据车牌号查询车辆信息
     *
     * @param qycph 牵引车牌号
     * @param gcph  挂车牌号
     * @return
     */
    SqclxxVo selectByCph(String qycph, String gcph, String sqxxid);

    /**
     * 高速收费站最大通能力--分页查询
     *
     * @param page 当前页
     * @param rows 分页条数
     * @param zdmc 站点名称
     * @return
     */
    Page<ZdtxzzxxVo> gssfzzdtxnlPage(long page, long rows, String zdmc);

    /**
     * 根据sqxxid查询事项编码
     *
     * @param sqxxid  牵引车牌号
     * @return
     */
    boolean getSxbm(String sqxxid);

    /**
     * 查询是否存在注销记录
     * @param sqxxid 办件信息id
     * @return
     */
    boolean ifExistApply(String sqxxid);
}

