package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SssxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqclxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqcxxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.YhxxVo;

import java.util.List;

public interface BjdjService {

    /**
     * 办件登记分页查询
     * @param sssxVo 查询条件
     * @return List<SxxxVo> 办件登记信息分页数据
     */
    Page<SssxVo> bjdjPage(SssxVo sssxVo, long current, long size);

    /**
     * 根据车牌号与申请人信息查找车辆信息
     * @param sqxxVo 申请人信息
     * @return 申请车辆信息
     */
    SqclxxVo findClxxByCph(SqxxVo sqxxVo);

    /**
     * 检测申请人当前是否有正在办理的相同事项办件
     * 防止多次提交（网约车和省内超限件可以多次）
     * @param sqxxVo 申请信息
     * @return boolean
     */
    boolean checkCaseload(SqxxVo sqxxVo);

    /**
     * 填充申请信息
     * @param sqxxVo 申请信息
     * @return SqxxVo
     */
    SqxxVo fillSqxx(SqxxVo sqxxVo, SysUser sysUser);

    /**
     * 保存办件登记信息
     * @param sqxxVo 申请信息
     * @return boolean
     */
    boolean saveApplyInfo(SqxxVo sqxxVo, SysUser sysUser) throws Exception;

    /**
     * 保存申请超限信息
     * @param sqcxxxVo 申请超限信息
     * @return boolean
     */
    boolean saveSqcxInfo(SqcxxxVo sqcxxxVo, SysUser sysUser);

    /**
     * 根据实施事项编码查询相关的实施事项信息
     * 保存至申请信息
     * @param sssxbm 实施事项编码
     * @return SssxVo 实施事项信息
     */
    SssxVo findSssxInfo(String sssxbm);

    /**
     * 判断当前机构是否是安徽省交通运输综合执法监督局及其下属机构
     * @param jgid  当前机构id
     * @return boolean
     */
    boolean isZhzfj(String jgid);

    /**
     * 根据用户所在单位行政区划获取县交通局/市交通局/省交通厅的机构id
     * @param xzqhId  行政区划id
     * @return boolean
     */
    String getJgidByXzqh(String xzqhId);

    /**
     * 根据业户名称查询业户信息
     * @param yhxxVo 业户查询信息
     * @return YhxxVo 业户详细信息
     */
    YhxxVo findYhxxByYhmc(YhxxVo yhxxVo);

    /**
     * 根据申请信息id查询业户信息
     * @param sqxxid 申请信息id
     * @return YhxxVo 业户详细信息
     */
    YhxxVo findYhxxById(String sqxxid);

    /**
     * 根据申请人名称查询详细的申请人信息
     * @param sqr 申请人名称
     * @return List<SqxxVo>
     */
    List<SqxxVo> findSqrByName(String sqr);

    /**
     * 查询材料信息
     * @param sqxxid
     * @param sssxid
     * @return
     */
    /*List<SqclVo> findSxclById(String sqxxid,String sssxid);*/

    /**
     * 查询车辆信息
     * @param sqxxid
     * @param clfl
     * @return
     */
    SqclxxVo getClxxById(String sqxxid,String clfl);

    /**
     * 货物类别树
     * @return TreeDataVo
     */
    List<TreeDataVo> hwlbTree();

    /**
     * 经营范围树
     * @return TreeDataVo
     */
    List<TreeDataVo> getJyfwTree();

}
