package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;


import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.AjahVO;

/**
 * 案号 服务类
 *
 * @author 刘梦寻
 */
public interface AnHaoService {
    /**
     * 获取案号
     * @param ajbh 案件编号
     * @param orgShortName 单位简称
     * @param ajlx 案件类型
     *  @return
     */
    String getAnHao(String ajbh, String orgShortName, String ajlx);

    /**
     * 获取事件流水号
     * @param orgId 机构id
     * @return
     */
    String getShiJianLiuShuiHao(String orgId);

    /**
     * 获取案件顺序号
     * @param orgId 机构id
     * @return
     */
    String getAnJianShunXuHao(String orgId);

    /**
     * 获取案件顺序号（案号池获取）
     * @param orgId 机构id
     * @param ajlx 案件类型
     * @return
     */
    String getSXHByRedisDistributedLock(String orgId, String ajlx);

    /**
     * 回收案件案号
     * @param ajahVO 案号信息
     */
    void recycleAnHao(AjahVO ajahVO);
}
