package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 行政审批-审批记录
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-05-12
 */
@Data
@TableName("XZSP_J_SPJL")
public class XzspJSpjlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    @TableId
    private String spjlid;

    /**
     * 申请信息ID
     */
    private String sqxxid;

    /**
     * 工作流ID
     */
    private String gzlid;

    /**
     * 环节ID
     */
    private String hjid;

    /**
     * 环节编码
     */
    private String hjbm;

    /**
     * 环节名称
     */
    private String hjmc;

    /**
     * 阶段编码
     */
    private String jdbm;

    /**
     * 阶段名称
     */
    private String jdmc;

    /**
     * 操作编码
     */
    private String czbm;

    /**
     * 操作名称
     */
    private String czmc;

    /**
     * 审批意见
     */
    private String czyj;

    /**
     * 审批时间
     */
    private Date spsj;

    /**
     * 审批人ID
     */
    private String sprid;

    /**
     * 审批人
     */
    private String spr;

    /**
     * 机构ID
     */
    private String jgid;

    /**
     * 机构
     */
    private String jg;

    /**
     * 部门ID
     */
    private String bmid;

    /**
     * 部门
     */
    private String bm;

    /**
     * 环节类型代码
     */
    @TableField(exist = false)
    private String actClass;

    /**
     * 是否短信提示下一环节办理人员
     */
    @TableField(exist = false)
    private Boolean sfdxts;

    /**
     * 是否短信提示受理人员
     */
    @TableField(exist = false)
    private Boolean sfdxtsSl;

    /**
     * 受理通知书联系人
     */
    @TableField(exist = false)
    private String sltzlxr;

    /**
     * 受理通知书联系方式
     */
    @TableField(exist = false)
    private String sltzlxdh;

    /**
     * 工作流平台动作ID
     */
    @TableField(exist = false)
    private String actId;

    /**
     * 不予受理原因代码
     */
    @TableField(exist = false)
    private String byslyydm;

    /**
     * 补齐补正原因代码
     */
    @TableField(exist = false)
    private String bqbzyydm;

    /**
     * 修改路线原因代码
     */
    @TableField(exist = false)
    private String xglxyydm;

    /**
     * 修改路线涉及省份
     */
    @TableField(exist = false)
    private String xglxsjsf;

    /**
     * 途径省份
     */
    @TableField(exist = false)
    private String tjsf;

    /**
     * 大件运输类型代码：01 起运省 ； 02 沿线省
     */
    @TableField(exist = false)
    private String djyslxdm;

    /**
     * 是否需要勘验代码：0 不需要 ； 1 需要
     */
    @TableField(exist = false)
    private String sfxykydm;

    /**
     * 协调结果：true 协调通过 ； false 协调不通过
     */
    @TableField(exist = false)
    private String xtjgdm;

    /**
     * 协调不通过原因代码
     */
    @TableField(exist = false)
    private String xtbtgyydm;

    /**
     * 修改方案省份数组（字符串形式）
     */
    @TableField(exist = false)
    private String xgsfs;

    /**
     * 协调路线json字符串
     */
    @TableField(exist = false)
    private String xglxJson;

    /**
     * 办理结果：0501 批准办结 ； 0503 作废办结
     */
    @TableField(exist = false)
    private String bljgdm;

    /**
     * 案件是否是超限案件标志：0 不是； 1 是
     */
    @TableField(exist = false)
    private String cxFlag;

    /**
     * 是否政务对接：00 需要对接；01 无需对接
     */
    @TableField(exist = false)
    private String sfzwdj;

    /**
     * 许可决定书类型：01 许可决定书；02 变更决定书； 03 延续决定书
     */
    @TableField(exist = false)
    private String xkjdslx;

    /**
     * 符合依据条款
     */
    @TableField(exist = false)
    private String fhtk;

    /**
     * 准予活动内容
     */
    @TableField(exist = false)
    private String zyhd;

    /**
     * 复议时限(天)
     */
    @TableField(exist = false)
    private String ts;

    /**
     * 送达信息
     */
    @TableField(exist = false)
    private String sdxx;

    /**
     * 复议机关
     */
    @TableField(exist = false)
    private String fyjg;

    /**
     * 下一环节编码
     */
    @TableField(exist = false)
    private String nextHjbm;

    /**
     * 是否短信送达
     */
    @TableField(exist = false)
    private String sfdxsd;

    /**
     * 短信模板编码
     */
    @TableField(exist = false)
    private String dxmbcode;

    /**
     * 是否选择人员
     */
    @TableField(exist = false)
    private String sfxzry;

    /**
     * 下一步审批人员
     */
    @TableField(exist = false)
    private String xybspr[];

    @Override
    public String getId() {
        return spjlid;
    }

    @Override
    public void setId(String id) {
        this.spjlid = id;
    }


}
