package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 行政审批-跨省当前审批状态表
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-06-06
 */
@Data
@TableName("XZSP_J_KSDQSPZT")
public class XzspJKsdqspztVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键-跨省当前审批状态ID
     */
    private String ksdqspztid;

    /**
     * 申请信息ID
     */
    private String sqxxid;

    /**
     * 申请状态
     */
    private String sqzt;

    /**
     * 申请状态名称
     */
    @TableField(exist = false)
    private String sqztmc;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endtime;

    /**
     * 结束时间字符串
     */
    @TableField(exist = false)
    private String endtimeStr;

    /**
     * 行政区划代码
     */
    private String distCode;

    /**
     * 活动节点
     */
    private String activeNode;

    /**
     * 审查结果: true 审查通过；false 审查不通过
     */
    private String reviewFlag;

    /**
     * 审查意见
     */
    private String reviewComment;

    /**
     * 审查时间
     */
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reviewTime;

    /**
     * 审查时间字符串
     */
    @TableField(exist = false)
    private String reviewTimeStr;

    /**
     * 路线调整涉及省份
     */
    private String effect;

    /**
     * 版本号
     */
    private BigDecimal coordinateVersion;

    /**
     * 办件编号
     */
    @TableField(exist = false)
    private String reqNo;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 工作流Id
     */
    @TableField(exist = false)
    private String gzlid;

    /**
     * 工作流环节实例Id
     */
    @TableField(exist = false)
    private String activityinstid;

    /**
     * 工作流环节定义Id
     */
    @TableField(exist = false)
    private String activitydefid;

    /**
     * 工作流环节名称
     */
    @TableField(exist = false)
    private String activityinstname;

    /**
     * 工作流环节类型代码
     */
    @TableField(exist = false)
    private String actclass;

    /**
     * 途径省份
     */
    @TableField(exist = false)
    private String passDists;

    /**
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhmc;

    /**
     * 事项实施机构Id
     */
    @TableField(exist = false)
    private String sxssjgid;

    @TableField(exist = false)
    private String date;

    @TableField(exist = false)
    private String time;

    @TableField(exist = false)
    private String year;

    @TableField(exist = false)
    private String month;

    @TableField(exist = false)
    private String day;

    @TableField(exist = false)
    private String hours;

    @TableField(exist = false)
    private String minutes;

    @TableField(exist = false)
    private String seconds;

    @Override
    public String getId() {
        return ksdqspztid;
    }

    @Override
    public void setId(String id) {
        this.ksdqspztid = id;
    }

    public String getRequestStatus() {
        return sqzt;
    }

    public void setRequestStatus(String sqzt) {
        this.sqzt = sqzt;
    }
}
