package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 网约车驾驶员考试
 * </p>
 *
 * @author ln
 * @since 2020-05-26
 */
@Data
@TableName("XZSP_J_WYCJSY")
public class WycjsyVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 网约车驾驶员ID
     */
    @TableId
    private String wycjsyid;

    /**
     * 报考编号
     */
    private String bkbh;

    /**
     * 申請信息ID
     */
    private String sqxxid;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 性别
     */
    private String xb;

    /**
     * 出生日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date csrq;

    /**
     * 身份证号
     */
    private String sfzh;

    /**
     * 家庭住址
     */
    private String jtzz;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 文化程度
     */
    private String whcd;

    /**
     * 准驾车型
     */
    private String zjcx;

    /**
     * 驾驶证初领日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date jzclrq;

    /**
     * 考点名称
     */
    private String kdmc;

    /**
     * 准考证号
     */
    private String zkzh;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 行政区划名称
     */
    private String xzqhmc;

    /**
     * 报考类别
     */
    private String bklb;

    /**
     * 报考时间
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date bksj;

    /**
     * 准考证号
     */

    /**
     * 公共科目分数
     */
    private String ggkfs;

    /**
     * 区域科目分数
     */
    private String qykfs;

    /**
     * 是否通过
     */
    private String sftg;

    /**
     * 申请办证标识:0未申请1已申请
     */
    private String isApply;

    /**
     * 申请办证时间
     */
    private Date sqrq;

    /**
     * 0未受理，1已受理，2已注销
     */
    private String slzt;

    /**
     * 39 send_flg 标记
     * 1已受理，2已注销，3获取出错，4已生成案号
     */
    @TableField(exist = false)
    private String sendFlag;

    /**
     * 39 update_flg 标记
     */
    @TableField(exist = false)
    private String updateFlag;

    /**
     * 受理状态数组 前端字段
     */
    @TableField(exist = false)
    private String[] slztOpt;

    /**
     * 报考时间开始  前端字段
     */
    @TableField(exist = false)
    private String bksjks;

    /**
     * 报考时间结束 前端字段
     */
    @TableField(exist = false)
    private String bksjjs;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 实施事项id
     */
    @TableField(exist = false)
    private String sssxid;

    /**
     * 实施事项名称
     */
    @TableField(exist = false)
    private String sssxmc;

    /**
     * 实施事项编码
     */
    @TableField(exist = false)
    private String sssxbm;

    /**
     * 事项编码
     */
    @TableField(exist = false)
    private String sxbm;

    /**
     * 事项信息id
     */
    @TableField(exist = false)
    private String sxxxid;

    /**
     * 审批流程
     */
    @TableField(exist = false)
    private String splc;

    /**
     * 登记页面地址
     */
    @TableField(exist = false)
    private String djymdz;

    /**
     * 事项材料目录id
     */
    @TableField(exist = false)
    private String sxclmlid;

    /**
     * 行政区划数组
     */
    @TableField(exist = false)
    private String[] xzqhs;

    /**
     * 申请人证件类型
     */
    @TableField(exist = false)
    private String sqrzjlxdm;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     * 工作流id
     */
    @TableField(exist = false)
    private Long gzlid;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String activityinstid;

    /**
     * 环节id
     */
    @TableField(exist = false)
    private String hjid;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     * 环节编码
     */
    @TableField(exist = false)
    private String hjbm;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String mainprocinstid;

    @Override
    public String getId() {
        return wycjsyid;
    }

    @Override
    public void setId(String id) {
        this.wycjsyid = id;
    }


}
