package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 网约车车辆申请
 * </p>
 *
 * @author ln
 * @since 2020-05-21
 */
@Data
@TableName("XZSP_J_WYCCLXX")
public class WycclxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 网约车车辆信息ID
     */
    @TableId
    private String wycclxxid;

    /**
     * 申请事件ID
     */
    private String sqxxid;

    /**
     * 车辆内码
     */
    private String clnm;

    /**
     * 车辆牌照号
     */
    private String cphm;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 车辆所有人
     */
    private String clsyr;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 车辆所有人身份证号
     */
    private String syrsfz;

    /**
     * 车辆所有人现居住地址
     */
    private String syrxj;

    /**
     * 法人代表姓名
     */
    private String frdb;

    /**
     * 法人代表身份证
     */
    private String frsfz;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 行政区划名称
     */
    private String xzqhmc;

    /**
     * 车辆首次注册登记日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date clscdjrq;

    /**
     * 行驶证发证机关
     */
    private String xszfzjg;

    /**
     * 行驶证申领地区划
     */
    private String xszsldqh;

    /**
     * 行驶证申领地名称
     */
    private String xszsldm;

    /**
     * 车辆类型
     */
    private String cllx;

    /**
     * 车辆品牌
     */
    private String clpp;

    /**
     * 车身颜色
     */
    private String clys;

    /**
     * 车辆识别号
     */
    private String clsbh;

    /**
     * 车辆型号
     */
    private String clxh;

    /**
     * 行驶证检验有效期至
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date xszjyyxrq;

    /**
     * 发动机号
     */
    private String fdjh;

    /**
     * 燃料类型
     */
    private String rllx;

    /**
     * 排量
     */
    private String pl;

    /**
     * 排量类别
     */
    private String pllb;

    /**
     * 车长
     */
    private Integer cc;

    /**
     * 车宽
     */
    private Integer ck;

    /**
     * 车高
     */
    private Integer cg;

    /**
     * 轴距
     */
    private Integer zj;

    /**
     * 核定载客数
     */
    private Integer hdzks;

    /**
     * 使用性质
     */
    private String syxz;

    /**
     * 申请人
     */
    private String sqr;

    /**
     * 申请时间
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date sqsj;

    /**
     * 申请类别：新购、再用
     */
    private String sqlb;

    /**
     * 0未受理，1已受理，2已注销
     */
    private String slzt;

    /**
     * 汽车驾驶员是否自我提出申请办证
     */
    private String isApply;

    /**
     * 39 send_flg 标记
     * 1已受理，2已注销，3获取出错，4已生成案号
     */
    @TableField(exist = false)
    private String sendFlag;

    /**
     * 39 update_flg 标记
     * I 新增， U 更新，D 删除
     */
    @TableField(exist = false)
    private String updateFlag;

    /**
     * 申请日期
     */
    @TableField(exist = false)
    private String sqrq;

    /**
     * 申请日期开始
     */
    @TableField(exist = false)
    private String sqrqks;

    /**
     * 申请日期结束
     */
    @TableField(exist = false)
    private String sqrqjs;

    /**
     * 受理状态数组
     */
    @TableField(exist = false)
    private String[] slztOpt;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 实施事项id
     */
    @TableField(exist = false)
    private String sssxid;

    /**
     * 实施事项名称
     */
    @TableField(exist = false)
    private String sssxmc;

    /**
     * 实施事项编码
     */
    @TableField(exist = false)
    private String sssxbm;

    /**
     * 事项编码
     */
    @TableField(exist = false)
    private String sxbm;

    /**
     * 事项信息id
     */
    @TableField(exist = false)
    private String sxxxid;

    /**
     * 审批流程
     */
    @TableField(exist = false)
    private String splc;

    /**
     * 登记页面地址
     */
    @TableField(exist = false)
    private String djymdz;

    /**
     * 事项材料目录id
     */
    @TableField(exist = false)
    private String sxclmlid;

    /**
     * 行政区划数组
     */
    @TableField(exist = false)
    private String[] xzqhs;

    /**
     * 申请人证件类型
     */
    @TableField(exist = false)
    private String sqrzjlxdm;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     * 工作流id
     */
    @TableField(exist = false)
    private Long gzlid;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String activityinstid;

    /**
     * 环节id
     */
    @TableField(exist = false)
    private String hjid;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     * 环节编码
     */
    @TableField(exist = false)
    private String hjbm;

    /**
     * 当前环节
     */
    @TableField(exist = false)
    private String mainprocinstid;

    @Override
    public String getId() {
        return wycclxxid;
    }

    @Override
    public void setId(String id) {
        this.wycclxxid = id;
    }

}
