package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 文书修改记录
 * @author huangchao
 * @date 2021/11/24
 */
@Data
@TableName("XZSP_J_WSXGJL")
public class WsxgjlVo implements Serializable {
    private static final long serialVersionUID = 233125543L;

    @TableId("WSXGJLID")
    private String wsxgjlId;

    /**
     * 修改前文书历史记录模板
     */
    private String valueHisBeforeId;

    /**
     * 修改后文书历史记录id
     */
    private String valueHisAfterId;

    /**
     * 文书id
     */
    private String valueId;

    /**
     * 文书模板id
     */
    private String wordTemplateId;

    /**
     * 事件id（申请信息id）
     */
    private String eventId;

    /**
     * 申请所属机构id
     */
    private String orgId;

    /**
     * 文书名称
     */
    private String docName;

    /**
     * 审批意见
     */
    private String opinion;

    /**
     * 申请记录状态（0：待处理 1：同意申请 2：未同意申请）
     */
    private String status;

    /**
     * 申请人
     */
    private String creater;

    private Date createTime;

    /**
     * 审批人
     */
    private String updater;

    private Date updateTime;

    private String deleteFlag;

    /**
     * 办件编号
     */
    @TableField(exist = false)
    private String bjbm;
    /**
     * 工作流ID
     */
    @TableField(exist = false)
    private Long gzlid;
    /**
     * 申请人姓名
     */
    @TableField(exist = false)
    private String sqr;
    /**
     * 事项实施机构名称
     */
    @TableField(exist = false)
    private String orgName;

    @TableField(exist = false)
    private String activityinstid;
    /**
     * 当前环节编码
     */
    @TableField(exist = false)
    private String hjbm;
    /**
     * 当前环节id
     */
    @TableField(exist = false)
    private String hjid;

    /**
     * 当前环节名称
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     * 当前环节名称数组
     */
    @TableField(exist = false)
    private String[] hjmcArr;

    /**
     * 查询开始时间
     */
    @TableField(exist = false)
    public String beginTime;

    /**
     * 查询结束时间
     */
    @TableField(exist = false)
    public String endTime;
}
