package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 行政审批-申请信息
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-04-22
 */
@Data
@TableName("XZSP_J_SQXX")
public class SqxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    @TableId
    private String sqxxid;

    /**
     * 结果送达方式
     */
    private String jgsdfsdm;

    /**
     * 申请人证件类型
     */
    private String sqrzjlxdm;

    /**
     * 事项类型
     */
    private String sxlxdm;

    /**
     * 事项类型数组
     */
    @TableField(exist = false)
    private String[] sxlxdmList;

    /**
     * 事项类型数组
     */
    @TableField(exist = false)
    private String[] spjgList;

    /**
     * 事项信息id
     */
    private String sxxxid;

    /**
     * 办件类型
     */
    private String bjlxdm;

    /**
     * 办件类型数组
     */
    @TableField(exist = false)
    private String[] bjlxdmList;

    /**
     * 审批結果
     */
    private String spjgdm;

    /**
     * 审批机构
     */
    @TableField(exist = false)
    private String spjg;

    /**
     * 政务服务网办件唯一编号 办件编号
     */
    private String bjbm;

    /**
     * 案号
     */
    private String ah;

    /**
     * 工作流ID
     */
    private Long gzlid;

    /**
     * 政务事项编码  实施事项编码
     */
    private String sssxbm;

    /**
     * 实施事项版本号
     */
    private Long sssxbbh;

    /**
     * 实施事项名称
     */
    private String sssxmc;

    /**
     * 交通标准事项编码 事项编码
     */
    private String sxbm;

    /**
     * 事项版本号
     */
    private Long sxbbh;

    /**
     * 事项名称
     */
    private String sxmc;

    /**
     * 申请时的具体申请名称 申请事项
     */
    private String sqsx;

    /**
     * 申请人
     */
    private String sqr;

    /**
     * 申请人证件号码
     */
    private String sqrzjhm;

    /**
     * 联系方式
     */
    private String lxfs;

    /**
     * 无代理人，为申请人，经办人
     */
    private String lxrdlrxm;

    /**
     * 经办人
     */
    private String lxrdlrzjlxdm;

    /**
     * 经办人
     */
    private String lxrdlrzjhm;

    /**
     * 联系人手机号码
     */
    private String lxrsjhm;

    /**
     * 邮编
     */
    private String yb;

    /**
     * 通讯地址
     */
    private String txdz;

    /**
     * 法定代表人
     */
    private String fddbr;

    /**
     * 法定代表人证件类型代码
     */
    private String fddbrzjlxdm;

    /**
     * 法定代表人证件号码
     */
    private String fddbrzjhm;

    /**
     * 申请日期
     */
    private Date sqrq;

    /**
     * 申请日期开始
     */
    @TableField(exist = false)
    private String  sqrqKs;

    /**
     * 申请日期结束
     */
    @TableField(exist = false)
    private String  sqrqJs;

    /**
     * 受理日期
     */
    private Date slrq;

    /**
     * 承诺办结日期
     */
    private Date cbbjri;

    /**
     * 办结日期
     */
    private Date bjrq;

    /**
     * 申请日期开始
     */
    @TableField(exist = false)
    private String  jdrqKs;

    /**
     * 申请日期结束
     */
    @TableField(exist = false)
    private String  jdrqJs;

    /**
     * 归档日期
     */
    private Date gdrq;

    /**
     * 许可日期
     */
    private Date xkrq;

    /**
     * 受理机构ID
     */
    private String jgid;

    /**
     * 受理机构
     */
    private String jg;

    /**
     * 当前审批机构ID
     */
    private String dqspjgid;

    /**
     * 当前审批环节审批机构
     */
    private String dqspjg;

    /**
     * 收件人ID
     */
    private String sjrid;

    /**
     * 收件人
     */
    private String sjr;

    /**
     * 邮寄地址
     */
    private String yjdz;

    /**
     * 收件人电话
     */
    private String sjrdh;

    /**
     * 投资平台代码
     */
    private String tzptdm;

    /**
     * 是否投资项目 1是0否
     */
    private String sftzxm;

    /**
     * 实施事项id
     */
    @TableField(exist = false)
    private String sssxid;


    @TableField(exist = false)
    private String[] sftzxmList;

    /**
     * 投资项目代码
     */
    private String tzxmdm;

    /**
     * 所属地区编码
     */
    private String ssdqbm;

    /**
     * 事项对应的6位地区编码  + 9位组织机构编码 + 3位系统编码组成；默认系统编码为000，标识政务服务运行管理系统
     */
    private String ssdw;

    /**
     * 01：办理中，02：已办结未归档，03：已归档

     */
    private String zt;

    @TableField(exist = false)
    private String[] ztList;

    /**
     * 勘验状态
     */
    @TableField(exist = false)
    private String kyzt;

    /**
     * 结果证件
     */
    private String zjlxbm;

    /**
     * 结果证件
     */
    private String zjmc;

    /**
     * 各类证件ID
     */
    private String zjid;

    /**
     * 结果证件
     */
    private String zjhm;

    /**
     * 案件来源：01 窗口, 02 大件运输, 03 政务网, 04 网约车
     */
    private String ajly;

    @TableField(exist = false)
    private String[] ajlyList;

    /**
     * 许可结果：01 准予许可；02 不予许可
     */
    private String xkjg;

    /**
     * 许可理由
     */
    private String xkly;

    /**
     * 许可有效期起
     */
    private Date xkyxqq;

    /**
     * 许可有效期止
     */
    private Date xkyxqz;

    /**
     * 许可机构Id
     */
    private String xkjgid;

    /**
     * 许可机构名称
     */
    private String xkjgmc;

    /**
     * 事项所属机构Id
     */
    private String sxssjgid;

    /**
     * 事项所属机构名称
     */
    private String sxssjgmc;

    /**
     * 政务机构Id(收件机构)
     */
    private String zwjgid;

    /**
     * 政务机构名称(收件机构)
     */
    private String zwjgmc;

    /**
     * 对接ODS数据库标志 0 未对接 1 已对接  9 记录被注销
     */
    private String odsFlag;

    /**
     * 许可有效期起字符串
     */
    @TableField(exist = false)
    private String xkyxqqStr;

    /**
     * 许可有效期止字符串
     */
    @TableField(exist = false)
    private String xkyxqzStr;
    /**
     * 当前环节编码
     */
    @TableField(exist = false)
    private String hjbm;
    /**
     * 当前环节id
     */
    @TableField(exist = false)
    private String hjid;

    /**
     * 当前环节名称
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     * 当前环节名称数组
     */
    @TableField(exist = false)
    private String[] hjmcArr;

    /**
     * 审批流程
     */
    @TableField(exist = false)
    private String splc;
    /**
     *工作流环节实例id
     */
    @TableField(exist = false)
    private Long activityinstid;
    /**
     * 车牌号
     */
    @TableField(exist = false)
    private String cph;

    /**
     * 申请超限json 对应前端
     */
    @TableField(exist = false)
    private String sqcxJson;

    /**
     * 申报材料json 对应前端
     */
    @TableField(exist = false)
    private String sbclJson;

    /**
     * 申请人Json 对应前端
     */
    @TableField(exist = false)
    private String sqrJson;

    /**
     * 许可信息Json 对应前端
     */
    @TableField(exist = false)
    private String xkInfoJson;

    /**
     * 送达信息Json 对应前端
     */
    @TableField(exist = false)
    private String sdInfoJson;

    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     * 查询范围数组
     */
    @TableField(exist = false)
    private String[] cxfwList;

    @TableField(exist = false)
    private String[] zxzt;

    /**
     * 事项材料目录id
     */
    @TableField(exist = false)
    private String sxclmlid;
    /**
     * 承诺办结时限
     */
    @TableField(exist = false)
    private String cnbjsx;

    /**
     * 原办件编号
     */
    @TableField(exist = false)
    private String oldReqNo;

    /**
     * 案件来源名称
     */
    @TableField(exist = false)
    private String ajlymc;

    /**
     * 当前服务器时间
     */
    @TableField(exist = false)
    private Date curDate;

    /**
     * 车辆首次注册登记日期
     */
    @TableField(exist = false)
    private Date clsczcDate;

    /**
     * 是否政务网对接事项
     */
    @TableField(exist = false)
    private String sfzwdj;
    
    /**
     * 是否有业务字段0无1有机构id2有业务字段
     */
    @TableField(exist = false)
    private String sfyywzd;
    
    /**
     * 机构编码
     */
    @TableField(exist = false)
    private String orgCode;
    
    @TableField(exist = false)
    private String[] orgIds;
    
    @TableField(exist = false)
    private String[] sxbms;

    /**
     * 车辆识别号（车架号）
     */
    @TableField(exist = false)
    private String clsbh;

    /**
     * 车辆区划代码
     */
    @TableField(exist = false)
    private String clqhdm;

    /**
     * 公路案号
     */
    @TableField(exist = false)
    private String glAnHao;

    /**
     * 环节定义ID
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     * 流程ID
     */
    @TableField(exist = false)
    private Long mainProcessInstId;

    /**
     * 流程编码
     */
    @TableField(exist = false)
    private String processdefcode;


    /**
     * 线索id
     */
    @TableField(exist = false)
    private String xsid;

    /**
     * 文书模板名称
     */
    @TableField(exist = false)
    private String wordTemplateName;

    /**
     * 线索类型
     */
    @TableField(exist = false)
    private String xslx;

    /**
     * 是否有推送新文书
     */
    @TableField(exist = false)
    private String sfytsxws;

    /**
     * 交警回复标志
     */
    @TableField(exist = false)
    private String jjhfFlag;

    @TableField(exist = false)
    private String kycl;

    @TableField(exist = false)
    private String kyOrgId;

    /**
     * 通行路线
     */
    @TableField(exist = false)
    private String txlx;

    /**
     * 案件类别
     */
    @TableField(exist = false)
    private String djlb;

    /**
     * 是否修改路线
     */
    @TableField(exist = false)
    private String sfxglx;

    /**
     * 行政区划编码--给安徽交通厅提供页面所需参数
     */
    @TableField(exist = false)
    private String xzqhbm;

    @Override
    public String getId() {
        return sqxxid;
    }

    @Override
    public void setId(String id) {
        this.sqxxid = id;
    }


}
