package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 申请通行路线信息Vo
 * </p>
 *
 * @author ln
 * @since 2020-06-05
 */
@Data
@TableName("XZSP_J_SQTXLXXX")
public class SqtxlxxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 申请通行路线信息ID
     */
    @TableId
    private String sqtxlxxxid;

    /**
     * 申请信息ID
     */
    private String sqxxid;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 省（界）起点
     */
    private String sjqd;

    /**
     * 省内路线描述
     */
    private String snlxms;

    /**
     * 省（界）终点
     */
    private String sjzd;

    /**
     * 路线状态
     */
    private String lxzt;

    /**
     * 排序
     */
    private Long px;

    /**
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhmc;

    @Override
    public String getId() {
        return sqtxlxxxid;
    }

    @Override
    public void setId(String id) {
        this.sqtxlxxxid = id;
    }


}
