package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 行政审批-申请超限信息-历史数据表 实体类
 * </p>
 *
 * @author 刘梦寻
 * @since 2022-02-18
 */
@Data
@TableName("XZSP_J_SQCXXX_OLD")
public class SqcxxxoldVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 申请超限信息ID
     */
    @TableId
    private String sqcxxxid;

    /**
     * 超限信息编码
     */
    private String reqNo;

    /**
     * 原办件编号
     */
    private String oldReqNo;

    /**
     * 申请信息ID
     */
    private String sqxxid;

    /**
     * 是否跨省 1是0否
     */
    private String sfks;

    /**
     * 申请状态
     */
    private String sqzt;

    /**
     * 行驶时间开始日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date xsksrq;

    /**
     * 行驶时间结束日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date xsjsrq;

    /**
     * 起运省份
     */
    @TableField(exist = false)
    private String qysf;

    /**
     * 途经省份
     */
    private String tjsf;

    /**
     * 途经地
     */
    @TableField(exist = false)
    private String tjd;

    /**
     * 起运地行政区划
     */
    private String qydxzqh;

    /**
     * 目的地行政区划
     */
    private String mddxzqh;

    /**
     * 通行路线
     */
    private String txlx;

    /**
     * 货物类别
     */
    private String hwlb;

    /**
     * 货物名称
     */
    private String hwmc;

    /**
     * 车辆荷载
     */
    private String clhz;

    /**
     * 各车轴轴载
     */
    private String gczzz;

    /**
     * 货物重量(KG)
     */
    private Double hwzl;

    /**
     * 货物最大长(MM)
     */
    private Double hwzdc;

    /**
     * 货物最大宽(MM)
     */
    private Double hwzdk;

    /**
     * 货物最大高(MM)
     */
    private Double hwzdg;

    /**
     * 车货总重量(KG)
     */
    private Double chzzl;

    /**
     * 车货最大长(MM)
     */
    private Double chzdc;

    /**
     * 车货最大宽(MM)
     */
    private Double chzdk;

    /**
     * 车货最大高(MM)
     */
    private Double chzdg;

    /**
     * 轮胎数
     */
    private Long lts;

    /**
     * 轴数
     */
    private Long zs;

    /**
     * 轴距(MM)
     */
    private String zj;

    /**
     * 轴荷(KG)
     */
    private String zh;

    /**
     * 道路运输经营许可证编号
     */
    private String dlysjyxkzh;

    /**
     * 大件类别
     */
    private String djlb;

    /**
     * 有效范围
     */
    private String yxfw;

    /**
     * 勘验处理（0未勘验，1已勘验，2，无需勘验，3勘验不通过）
     */
    private String kycl;

    private String transPlan;

    private String ended;

    /**
     * 通行计划key
     */
    private String transPlanKey;

    private String transProvincial;

    /**
     * 通行计划名称
     */
    private String transplanName;

    /**
     * 经办人身份证图
     */
    private String agentIdImg;

    /**
     * 组织机构代码证图
     */
    private String regImg;

    /**
     * 营业执照图
     */
    private String bizImg;

    /**
     * 经营许可证图
     */
    private String orgCertImg;

    /**
     * 法人身份证图
     */
    private String masterIdImg;

    /**
     * 授权书图
     */
    private String authorizeImg;

    /**
     * 承诺书图
     */
    private String promiseImg;

    /**
     * 车货照片
     */
    private String totalImg;

    /**
     * 其他照片
     */
    private String otherImg;

    /**
     * 护送方案
     */
    private String planDoc;

    /**
     * 通行次数
     */
    private String txcs;

    /**
     * 更新时间-跨省大件更新时间
     */
    private Date gxsj;

    /**
     * 大件运输创建时间
     */
    private Date cjsj;

    /**
     * 是否修改路线
     */
    private String sfxglx;

    /**
     * 牵引车/货车牌号    */
    @TableField(exist = false)
    private String qycph;

    /**
     * 牵引车厂牌型号    */
    @TableField(exist = false)
    private String qycpxh;

    /**
     * 牵引车整备质量
     */
    @TableField(exist = false)
    private String qyzbzl;

    /**
     * 车辆整备质量
     */
    @TableField(exist = false)
    private Double clzbzl;

    /**
     * 挂车牌号
     */
    @TableField(exist = false)
    private String gcph;

    /**
     * 挂车厂牌型号    */
    @TableField(exist = false)
    private String gccpxh;

    /**
     * 挂车整备质量    */
    @TableField(exist = false)
    private String gczbzl;

    @Override
    public String getId() {
        return sqcxxxid;
    }

    @Override
    public void setId(String id) {
        this.sqcxxxid = id;
    }

}
