package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 行政审批-超限信息草稿表 实体类
 * </p>
 *
 * @author ln
 * @since 2020-12-15
 */
@Data
@TableName("XZSP_J_SQCXXX_DRAFT")
public class SqcxdraftVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 申请超限信息ID
     */
    @TableId
    private String cxdraftid;

    /**
     * 超限信息编码
     */
    private String sqdraftid;

    /**
     * 是否跨省 1是0否
     */
    private String sfks;

    /**
     * 行驶开始日期
     */
    private Date xsksrq;

    /**
     * 行驶结束日期
     */
    private Date xsjsrq;

    /**
     * 途经省份
     */
    private String tjsf;

    /**
     * 起运地行政区划
     */
    private String qydxzqh;

    /**
     * 起运地名称
     */
    private String qydmc;

    /**
     * 目的地行政区划
     */
    private String mddxzqh;

    /**
     * 目的地名称
     */
    private String mddmc;

    /**
     * 通行路线
     */
    private String txlx;

    /**
     * 货物类别
     */
    private String hwlb;

    /**
     * 货物名称
     */
    private String hwmc;

    /**
     * 车辆荷载
     */
    private String clhz;

    /**
     * 货物重量(KG)
     */
    private Double hwzl;

    /**
     * 货物最大长(MM)
     */
    private Double hwzdc;

    /**
     * 货物最大宽(MM)
     */
    private Double hwzdk;

    /**
     * 货物最大高(MM)
     */
    private Double hwzdg;

    /**
     * 车货总重量(KG)
     */
    private Double chzzl;

    /**
     * 车货总重量(KG)
     */
    @TableField(exist = false)
    private String chzzlStr;

    /**
     * 车货最大长(MM)
     */
    private Double chzdc;

    /**
     * 车货最大长(MM)
     */
    @TableField(exist = false)
    private String chzdcStr;

    /**
     * 车货最大宽(MM)
     */
    private Double chzdk;

    /**
     * 车货最大宽(MM)
     */
    @TableField(exist = false)
    private String chzdkStr;

    /**
     * 车货最大高(MM)
     */
    private Double chzdg;

    /**
     * 车货最大高(MM)
     */
    @TableField(exist = false)
    private String chzdgStr;

    /**
     * 轮胎数
     */
    private Long lts;

    /**
     * 轴数
     */
    private Long zs;

    /**
     * 轴距(MM)
     */
    private String zj;

    /**
     * 轴荷(KG)
     */
    private String zh;

    /**
     * 道路运输经营许可证编号
     */
    private String dlysjyxkzh;

    /**
     * 大件类别
     */
    private String djlb;

    /**
     * 有效范围
     */
    private String yxfw;

    /**
     * 通行次数
     */
    private String txcs;

    /**
     * /货车信息Json
     */
    @TableField(exist =  false)
    private String qycJson;

    /**
     * 牵引车/货车牌号    */
    private String qycph;

    /**
     * 牵引车厂牌型号    */
    @TableField(exist = false)
    private String qycpxh;

    /**
     * 牵引车整备质量
     */
    @TableField(exist = false)
    private String qyzbzl;

    /**
     * 车辆整备质量
     */
    @TableField(exist = false)
    private Double clzbzl;

    /**
     * 挂车信息Json
     */
    @TableField(exist = false)
    private String gcJson;

    /**
     * 挂车牌号
     */
    private String gcph;

    /**
     * 挂车厂牌型号    */
    @TableField(exist = false)
    private String gccpxh;

    /**
     * 挂车整备质量    */
    @TableField(exist = false)
    private String gczbzl;

    /**
     * 通行开始日期 对应前端字段
     */
    @TableField(exist = false)
    private String txksrq;

    /**
     * 通行结束日期 对应前端字段
     */
    @TableField(exist = false)
    private String txjsrq;

    @Override
    public String getId() {
        return cxdraftid;
    }

    @Override
    public void setId(String id) {
        this.cxdraftid = id;
    }

}
