package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import java.util.Date;

import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;

import lombok.Data;

import org.springframework.format.annotation.DateTimeFormat;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 
 * @author Nier
 *
 */
@Data
@TableName("XZSP_J_SQCLBGXX")
public class SqclbgxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 申请车辆信息ID
     */
	@TableId
    private String sqclbgxxid;

    /**
     * 车辆变更状态
     * 0初审1终审2结束
     */
    private String clbgzt;
    /**
     * 车辆变更状态办理中
     */
    @TableField(exist = false)
    private String clbgztBlz;

    /**
     * 处理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date clsj;

    /**
     * 办件编号
     */
    private String bjbh;

    /**
     * 初审单位id
     */
    private String csdwid;

    /**
     * 车牌号
     */
    private String cph;
    
    /**
     * 查询条件
     */
    @TableField(exist = false)
    private String startSqsj;
    @TableField(exist = false)
    private String endSqsj;
    @TableField(exist = false)
    private String startClsj;
    @TableField(exist = false)
    private String endClsj;
    @TableField(exist = false)
    private String clbgztReg;

    @Override
    public String getId() {
        return sqclbgxxid;
    }

    @Override
    public void setId(String id) {
        this.sqclbgxxid = id;
    }
}
