package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 行政审批-申请材料
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-04-22
 */
@Data
@TableName("XZSP_J_SQCL")
public class SqclVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId
    private String sqclid;

    /**
     * 版本号
     */
    private Long bbh;

    /**
     * 事项材料目录ID
     */
    private String sxclmlid;

    /**
     * 申请信息ID
     */
    private String sqxxid;

    /**
     * 材料名称
     */
    private String clmc;

    /**
     * 序号
     */
    private Long xh;

    /**
     * 附件名称
     */
    private String fjmc;

    /**
     * 附件地址
     */
    private String fjdz;

    /**
     * 审核结果
     */
    private String shjg;

    /**
     * 审核时间
     */
    private Date shsj;

    /**
     * 审核意见
     */
    private String shyj;

    /**
     * 审核人ID
     */
    private String shrid;

    /**
     * 必要性代码
     */
    private String byxdm;

    /**
     * 材料类别 01 纸质 02 电子
     */
    private String cllb;

    /**
     * 审核人
     */
    @TableField(exist = false)
    private String shry;

    /**
     * 其他系统材料唯一标识
     */
    private String qtxtclwybs;

    /**
     * 附件key
     */
    private String fileKey;

    /**
     * 办件编号
     */
    @TableField(exist = false)
    private String bjbm;

    /**
     * 附件数据
     */
    @TableField(exist = false)
    private String entity;

    /**
     * 附件类型
     */
    @TableField(exist = false)
    private String FjType;


    /**
     * 申请材料来源
     */
    @TableField(exist = false)
    private String sqclly;

    /**
     * 实施事项编码
     */
    @TableField(exist = false)
    private String sssxbm;

    @Override
    public String getId() {
        return sqclid;
    }

    @Override
    public void setId(String id) {
        this.sqclid = id;
    }


}
