package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 行政审批-申请信息草稿表
 * </p>
 *
 * @author 李念
 * @since 2020-12-15
 */
@Data
@TableName("XZSP_J_SQXX_DRAFT")
public class SqDraftVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    @TableId
    private String sqdraftid;

    /**
     * 申请信息草稿名称
     */
    private String sqdraftmc;

    /**
     * 申请人
     */
    private String sqr;

    /**
     * 申请人证件类型
     */
    private String sqrzjlxdm;

    /**
     * 申请人证件号码
     */
    private String sqrzjhm;

    /**
     * 申请时的具体申请名称 申请事项
     */
    private String sqsx;

    /**
     * 法定代表人
     */
    private String fddbr;

    /**
     * 法定代表人证件类型代码
     */
    private String fddbrzjlxdm;

    /**
     * 法定代表人证件号码
     */
    private String fddbrzjhm;

    /**
     * 无代理人，为申请人，经办人
     */
    private String lxrdlrxm;

    /**
     * 经办人
     */
    private String lxrdlrzjlxdm;

    /**
     * 经办人
     */
    private String lxrdlrzjhm;

    /**
     * 联系人手机号码
     */
    private String lxrsjhm;

    /**
     * 政务事项编码  实施事项编码
     */
    private String sssxbm;

    /**
     * 实施事项名称
     */
    private String sssxmc;

    /**
     * 邮编
     */
    private String yb;

    /**
     * 结果送达方式
     */
    private String jgsdfsdm;

    /**
     * 联系方式
     */
    private String lxfs;

    /**
     * 通讯地址
     */
    private String txdz;

    /**
     * 收件人
     */
    private String sjr;

    /**
     * 收件人电话
     */
    private String sjrdh;

    /**
     * 邮寄地址
     */
    private String yjdz;

    /**
     * 车牌号
     */
    @TableField(exist = false)
    private String gcph;

    /**
     * 车牌号
     */
    @TableField(exist = false)
    private String qycph;

    /**
     * 申请超限json 对应前端
     */
    @TableField(exist = false)
    private String sqcxJson;

    /**
     * 起运地名称
     */
    @TableField(exist = false)
    private String qydmc;

    /**
     * 货物名称
     */
    @TableField(exist = false)
    private String hwmc;

    /**
     * 通行路线
     */
    @TableField(exist = false)
    private String txlx;

    /**
     * 目的地名称
     */
    @TableField(exist = false)
    private String mddmc;

    @Override
    public String getId() {
        return sqdraftid;
    }

    @Override
    public void setId(String id) {
        this.sqdraftid = id;
    }


}
