package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *  省内上传超限信息Vo
 * </p>
 *
 * @author ln
 * @since 2020-06-13
 */
@Data
@TableName("XZSP_J_SNCXSCXX")
public class SncxscxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 省内超限上传信息ID
     */
    @TableId
    private String sncxscxxid;

    /**
     * 省内许可申请编号
     */
    private String pNo;

    /**
     * 申请信息id
     */
    private String sqxxid;

    /**
     * 申请状态
     */
    private String reqStatus;

    /**
     * 审批环节
     */
    private String optNode;

    /**
     * 审批环节编码
     */
    @TableField(exist = false)
    private String optNodeId;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 承运单位名称
     */
    private String cydwmc;

    /**
     * 道路运输经营许可证号
     */
    private String orgCertNo;

    /**
     * 受理单位
     */
    private String sldwmc;

    /**
     * 当前审批机构
     */
    private String dqspjg;

    /**
     * 经办人身份证号
     */
    private String agentId;

    /**
     * 经办人姓名
     */
    private String agentName;

    /**
     * 申请类型
     */
    private String sqlxdm;

    /**
     * 申请方式
     */
    private String sqfsdm;

    /**
     * 通行次数
     */
    private String txcs;

    /**
     * 行驶时间开始日期
     */
    private Date startDate;

    /**
     * 行驶时间结束日期
     */
    private Date endDate;

    private String beginDist;

    private String passDists;

    private String endDist;

    /**
     * 通行路线
     */
    private String txlx;

    /**
     * 货物类别
     */
    private String hwlb;

    private String hwmc;

    /**
     * 货物重量(KG)
     */
    private Double hwzl;

    /**
     * 货物最大长(MM)
     */
    private Double hwzdc;

    /**
     * 货物最大宽(MM)
     */
    private Double hwzdk;

    /**
     * 货物最大高(MM)
     */
    private Double hwzdg;

    /**
     * 车货总重量(KG)
     */
    private Double chzzl;

    /**
     * 车货最大长(MM)
     */
    private Double chzdc;

    /**
     * 车货最大宽(MM)
     */
    private Double chzdk;

    /**
     * 车货最大高(MM)
     */
    private Double chzdg;

    /**
     * 轮胎数
     */
    private Long lts;

    /**
     * 轴数
     */
    private Long zs;

    /**
     * 轴距
     */
    private String zj;

    /**
     * 轴荷
     */
    private String zh;

    /**
     * 超限车辆信息ID
     */
    private String cxclxxid;

    /**
     * 挂车车辆信息ID
     */
    private String gcclxxid;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 受理时间
     */
    private Date acceptTime;

    /**
     * 办结时间
     */
    private Date bjsj;

    /**
     * 撤销时间
     */
    private Date dropTime;

    /**
     * 流程时间
     */
    private Date optTime;

    /**
     * 上传状态  1上传受理成功  2上传准予许可成功 3上传不予许可成功 9上传失败
     */
    private String sendFlag;

    /**
     * 流程标记  0流程未上传  1流程已上传
     */
    private String lcFlag;

    /**
     * 返回值信息
     */
    private String resMessage;

    /**
     * 返回值编码
     */
    private String resCode;

    /**
     * 流程返回值信息
     */
    private String lcMessage;

    /**
     * 许可结果
     */
    private String xkjg;

    /**
     * 申请车辆信息数组
     */
    @TableField(exist =  false)
    private List<SqclxxVo> sqclxxVos;

    @Override
    public String getId() {
        return sncxscxxid;
    }

    @Override
    public void setId(String id) {
        this.sncxscxxid = id;
    }


}
