package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 公路桥梁信息
 * </p>
 *
 * @author ln
 * @since 2020-09-04
 */
@Data
@TableName("XZSP_J_GLQLXX")
public class GlqlVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 公路桥梁信息ID
     */
    private String glqlxxid;

    /**
     * 桥梁名称
     */
    private String qlmc;

    /**
     * 桥梁代码
     */
    private String qldm;

    /**
     * 桥梁中心桩号
     */
    private String zxzh;

    /**
     * 路线编号
     */
    private String lxbh;

    /**
     * 路线名称
     */
    private String lxmc;

    /**
     * 技术等级
     */
    private String jsdj;

    /**
     * 桥梁全长(米)
     */
    private String qlzc;

    /**
     * 跨径总长(米)
     */
    private String kjzc;

    /**
     * 单孔最大跨径(米)
     */
    private String dkzdkj;

    /**
     * 跨径组合(孔*米)
     */
    private String kjzh;

    /**
     * 桥梁全宽(米)
     */
    private String qlqk;

    /**
     * 桥面净宽(米)
     */
    private String qljk;

    /**
     * 按跨径分类代码
     */
    private String akjfldm;

    /**
     * 按跨径分类类型
     */
    private String akjfllx;

    /**
     * 按使用年限分类代码
     */
    private String asynxfldm;

    /**
     * 按使用年限分类类型
     */
    private String asynxfllx;

    /**
     * 结构类型代码
     */
    private String jglxdm;

    /**
     * 结构类型类型
     */
    private String jglxlx;

    /**
     * 材料代码
     */
    private String cldm;

    /**
     * 材料名称
     */
    private String clmc;

    /**
     * 桥墩类型代码
     */
    private String qdlxdm;

    /**
     * 桥墩类型类型
     */
    private String qdlxlx;

    /**
     * 设计荷载等级代码
     */
    private String sjhzdjdm;

    /**
     * 设计荷载等级等级
     */
    private String djhzdjlx;

    /**
     * 抗震等级代码
     */
    private String kzdjdm;

    /**
     * 抗震等级等级
     */
    private String kzdjlx;

    /**
     * 跨越地物代码
     */
    private String kydwdm;

    /**
     * 跨越地物类型
     */
    private String kydwlx;

    /**
     * 跨越地物名称
     */
    private String kydwmc;

    /**
     * 通航等级
     */
    private String thdj;

    /**
     * 墩台防撞设施类型
     */
    private String dtfzsslx;

    /**
     * 是否互通立交
     */
    private String sfhtlj;

    /**
     * 建设单位
     */
    private String jsdw;

    /**
     * 设计单位
     */
    private String sjdw;

    /**
     * 施工单位
     */
    private String sgdw;

    /**
     * 监理单位
     */
    private String jldw;

    /**
     * 修建年度
     */
    private String xjnd;

    /**
     * 建成通车日期
     */
    private String jctcrq;

    /**
     * 管养单位性质代码
     */
    private String gydwxzdm;

    /**
     * 管养单位名称
     */
    private String gydwmc;

    /**
     * 监管单位名称
     */
    private String hyglqkgjdwmc;

    /**
     * 收费性质代码
     */
    private String sfxzdm;

    /**
     * 收费性质性质
     */
    private String sfxzxz;

    /**
     * 评定等级代码
     */
    private String pdqkdm;

    /**
     * 评定等级等级
     */
    private String pdqkdj;

    /**
     * 技术状况评定日期
     */
    private String pdqkrq;

    /**
     * 技术状况评定单位
     */
    private String pdqkdw;

    /**
     * 最近一次改造情况改造年度
     */
    private String zjgzqkgznd;

    /**
     * 最近一次改造情况完工日期
     */
    private String zjgzqkwgrq;

    /**
     * 最近一次改造情况改造部位
     */
    private String zjgzqkgzbw;

    /**
     * 最近一次改造情况工程性质
     */
    private String zjgzqkgcxz;

    /**
     * 最近一次改造情况改造施工单位
     */
    private String zjgzqkgzsgdw;

    /**
     * 最近一次改造情况是否部补助项目
     */
    private String zjgzqksfbzxm;

    /**
     * 当前主要病害部位
     */
    private String dqzybhbw;

    /**
     * 当前主要病害
     */
    private String dqzybhbh;

    /**
     * 交通管制措施代码
     */
    private String jtgzcsdm;

    /**
     * 交通管制措施
     */
    private String jtgzcscs;

    /**
     * 所在政区代码
     */
    private String szzqdm;

    /**
     * 桥梁所在位置
     */
    private String qlszwz;

    /**
     * 是否宽路窄桥
     */
    private String sfklzq;

    /**
     * 是否在长大桥梁目录中
     */
    private String sfcdqlml;

    /**
     * 备注
     */
    private String bz;

    @Override
    public String getId() {
        return glqlxxid;
    }

    @Override
    public void setId(String id) {
        this.glqlxxid = id;
    }
    /**
     * 查询条件
     */
    @TableField(exist = false)
    private String qlzcq;
    @TableField(exist = false)
    private String qlzcz;
    @TableField(exist = false)
    private String qlqkq;
    @TableField(exist = false)
    private String qlqkz;

    /**
     * 桥梁净宽起
     */
    @TableField(exist = false)
    private String qljkq;

    /**
     * 桥梁净宽止
     */
    @TableField(exist = false)
    private String qljkz;
}
