package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 公路桥梁信息
 * </p>
 *
 * @author ln
 * @since 2020-09-04
 */
@Data
@TableName("XZSP_J_BZJL")
public class BzjlVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 备注记录ID
     */
    @TableId
    private String bzjlid;

    /**
     * 路线信息id
     */
    private String xxid;

    /**
     * 类型 （1 收费站 2 隧道 3 桥梁）
     */
    private String lx;

    /**
     * 备注内容
     */
    private String bznr;

    private String creater;

    @Override
    public String getId() {
        return bzjlid;
    }

    @Override
    public void setId(String id) {
        this.bzjlid = id;
    }
    /**
     * 查询条件
     */
    @TableField(exist = false)
    private String qlzcq;
    @TableField(exist = false)
    private String qlzcz;
    @TableField(exist = false)
    private String qlqkq;
    @TableField(exist = false)
    private String qlqkz;

    /**
     * 桥梁净宽起
     */
    @TableField(exist = false)
    private String qljkq;

    /**
     * 桥梁净宽止
     */
    @TableField(exist = false)
    private String qljkz;
}
