package com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity.MapPointEntity;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity.MapPolylineEntity;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity.TransportCapacityEntity;

import java.util.List;

public interface TransportmapService {

    /**
     * 分页查询枢纽坐标点
     * @param page 分页数
     * @param rows 当前页
     * @param snmc 枢纽名称
     * @return IPage<MapPointEntity>
     */
    IPage<MapPointEntity> searchMapPoint(int page, int rows, String snmc);

    /**
     * 查询所有的枢纽坐标点，标记在地图上
     * @return List<MapPointEntity>
     */
    List<MapPointEntity> findAllMapPoint();

    /**
     * 保存枢纽坐标信息（经纬度）
     * @param entity 枢纽坐标信息（经纬度）、枢纽名称
     * @return
     */
    int saveMapPoint(MapPointEntity entity);

    /**
     * 删除枢纽坐标
     * @param id 枢纽id
     */
    void delMapPoint(String id);

    /**
     * 分页查询线路信息
     * @param page 当前页
     * @param rows 分页数
     * @param qdid 起点id
     * @param zdid 终点id
     * @param sxx 上下行
     * @return IPage<MapPolylineEntity>
     */
    IPage<MapPolylineEntity> searchMapPolyline(int page, int rows, String qdid, String zdid, String sxx);

    /**
     * 根据线路id查询线路信息
     * @param xlid 线路id
     * @return
     */
    MapPolylineEntity findXlxxById(String xlid);

    /**
     * 查询所有的线路信息
     * @return List<MapPolylineEntity>
     */
    List<MapPolylineEntity> findAllMapPolyline();

    /**
     * 保存线路信息
     * @param entity 线路信息（起点、终点、路线中包含的经纬度）
     * @return
     */
    int saveMapPolyline(MapPolylineEntity entity);

    /**
     * 根据id删除线路
     * @param id 线路id
     */
    void delMapPolyline(String id);

}
