package com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity.TransportCapacityEntity;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity.TxnlspVo;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;

import java.util.List;

public interface TransportCapacityService {

    /**
     * 线路通行能力信息分页查询
     * @param page 当前页
     * @param rows 分页数
     * @return page 分页数据信息
     */
    IPage searchTransportCapacity(int page, int rows, String xlid);

    /**
     * 查询所有的路线通行能力
     * @return
     */
    List<TransportCapacityEntity> findAllTransportCapacity();

    /**
     * 保存线路通行能力信息
     * @param entity 通行能力信息
     * @return boolean
     */
    JsonResult saveTransportCapacity(TxnlspVo entity);

    /**
     * 新增线路的通行能力信息
     * @param entity 通行能力信息
     * @return boolean
     */
    JsonResult insertTransportCapacityByXlid(TransportCapacityEntity entity);

    /**
     * 根据id删除通行能力
     * @param id 通行能力信息id
     */
    void delTransportCapacity(String id);

    /**
     * 根据参数查询符合条件的线路详细信息
     * 查询出的数据表示符合通行条件  标绿色，其他表示不能通行 标红色
     * @param entity 车货总长、总宽、总高、总重及通行时间
     * @return List<TransportCapacityEntity>
     */
    List findTransportCapacityByParams(TxnlspVo entity);

    /**
     * 查找当前线路的历史版本信息
     * @param entity 查询条件（xlid 线路ID)
     * @return List<TransportCapacityEntity>
     */
    List<TxnlspVo> historyList(TxnlspVo entity);

    /**
     * 查询所有的通行能力审批信息
     * @param entity 查询条件 （所属大队，路线名，审批状态）
     * @return IPage<TransportCapacityEntity>
     */
    Page<TxnlspVo> approveCapacityList(long page, long rows, TxnlspVo entity);

    /**
     * 根据txnlspid 查询 通行能力审批详细信息
     * @param txnlspid 通行能力审批id
     * @return TxnlspVo 通行能力审批详细信息
     */
    TxnlspVo findTxnlspInfoById(String txnlspid);

    /**
     * 保存通行能力审批结果
     * @param entity
     * @return
     */
    boolean saveTxnlsp(TxnlspVo entity);

    /**
     * 根据id删除通行能力审批数据
     * @param txnlspid 通行能力审批id
     * @return boolean
     */
    boolean delTxnlInfo(String txnlspid);
}
