package com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * MapPointEntity
 *
 * @author wang.pengfei
 * @date 2020/07/15
 */
@TableName("XZSP_J_TXNLSP")
@Data
public class TxnlspVo extends BaseEntity<String> {

    @TableId
    private String txnlspid;

    /**
     * 路段通行能力ID
     */
    private String ldtxnlid;

    /**
     * 重量
     */
    private Double zl;

    /**
     * 长度
     */
    private Double cd;

    /**
     * 宽度
     */
    private Double kd;

    /**
     * 高度
     */
    private Double gd;

    /**
     * 暂不通行开始时间
     */
    private Date zbtxkssj;

    /**
     * 暂不通行开始时间
     */
    private Date zbtxjssj;

    /**
     * 审批意见
     */
    private String spyj;

    /**
     * 版本号
     */
    private String bbh;

    /**
     * 审批状态（ 00 未审批  01 同意  02 不同意）
     */
    private String spzt;

    /**
     * 备注
     */
    private String bz;

    /**
     * 路线编号
     */
    private String lxbh;

    /**
     * 修改人名称
     */
    private String updaterName;

    @TableField(fill = FieldFill.INSERT)
    public String deleteFlag = "00";

    /**
     * 线路名称
     */
    @TableField(exist = false)
    private String xlmc;

    /**
     * 审批状态数组
     */
    @TableField(exist = false)
    private String[] spztArr;

    /**
     * 通行能力id数组
     */
    @TableField(exist = false)
    private String[] txnlidArr;

    /**
     * 所属大队
     */
    @TableField(exist = false)
    private String ssdd;

    /**
     * 暂不通行开始时间Str
     */
    @TableField(exist = false)
    private String zbtxkssjStr;

    /**
     * 暂不通行结束时间Str
     */
    @TableField(exist = false)
    private String zbtxjssjStr;

    /**
     * 线路id
     */
    @TableField(exist = false)
    private String xlid;

    /**
     * 所属大队id
     */
    @TableField(exist = false)
    private String ssddid;

    /**
     * 用户权限
     */
    @TableField(exist = false)
    private String userCookie;

    @Override
    public String getId() {
        return this.txnlspid;
    }

    @Override
    public void setId(String id) {
        this.txnlspid = id;
    }
}
