package com.kdgcsoft.jt.xzzf.dubbo.xzsp.transportmap.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * TransportCapacityEntity
 *
 * @author wang.pengfei
 * @date 2020/07/16
 */
@TableName("XZSP_J_LDTXNL")
@Data
public class TransportCapacityEntity extends BaseEntity<String> {

    @TableId
    private String ldtxnlid;

    /**
     * 线路ID
     */
    private String xlid;

    /**
     * 重量
     */
    private Double zl;

    /**
     * 长度
     */
    private Double cd;

    /**
     * 宽度
     */
    private Double kd;

    /**
     * 高度
     */
    private Double gd;

    /**
     * 所属大队
     */
    private String ssdd;

    /**
     * 所属大队id
     */
    private String ssddid;

    /**
     * 路线编号
     */
    private String lxbh;


    @TableField(fill = FieldFill.INSERT)
    public String deleteFlag = "00";

    /**
     * 判断是否通过双击路线查看路线详情
     */
    @TableField(exist = false)
    private String viewType;

    /**
     * 通行路线
     */
    @TableField(exist = false)
    private String txlx;

    @Override
    public String getId() {
        return this.ldtxnlid;
    }

    @Override
    public void setId(String id) {
        this.ldtxnlid = id;
    }

}
