package com.kdgcsoft.jt.xzzf.dubbo.xzsp.rzcx;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.govAffairs.entity.GovLogVo;

import java.util.List;

/**
 *  申报取号日志查询
 *
 * @author SL
 * @since 2021-08-20
 */
public interface SbqhService {

    /**
     * 申报取号日志列表分页查询
     * @param page 分页信息
     * @param govLogVo 查询参数
     * @return
     */
    IPage<GovLogVo> Ipage(IPage page, GovLogVo govLogVo);

    /**
     * 申报取号日志查询selectById
     *
     * @param govlogid
     * @return
     */
    GovLogVo getGovLogVoById(String govlogid);

    /**
     * 根据申请信息ID数组获取申请信息-办件查询页面
     *
     * @param govlogIds 申请信息ID数组
     * @return
     */
    List<GovLogVo> selectByGovLogIds(String[] govlogIds);

    /**
     * 根据查询参数获取错误日志信息-政务网错误日志页面-所有
     *
     * @param govLogVo 查询参数
     * @return
     */
    List<GovLogVo> page(GovLogVo govLogVo);

    /**
     * 根据办件编码查询错误日志
     * @param bjbm 查询参数
     *
     * @return
     */
    GovLogVo selectGovLog(String bjbm);
}
