package com.kdgcsoft.jt.xzzf.dubbo.xzsp.otherSys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.otherSys.entity.CxApplyInfoVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.AjInfoVO;

import java.util.List;

/**
 * <p>
 * 行政审批-其他系统调用-查询信息 服务类
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-06-22
 */
public interface QueryInfoService {

    /**
     * 查询执法人员已办案件
     * @param ajInfoVO 查询参数
     * @return
     */
    Page<AjInfoVO> querySqxxByzfryId(long current, long size,AjInfoVO ajInfoVO);
    /**
     * 查询执法人员参与许可案件数
     * @param ajInfoVO
     * @return
     */
    AjInfoVO  queryXkAjSlToZfRy(AjInfoVO ajInfoVO);

    /**
     * 查询行政审批系统状态为“已办结”的行政许可办件
     * @param cxApplyInfoVo 查询条件
     * @return CxApplyInfoVo
     */
    List<CxApplyInfoVo> queryXkbjInfoByPysh(CxApplyInfoVo cxApplyInfoVo);

    /**
     * 查询行政审批系统行政许可办件列表信息
     * @param cxApplyInfoVo 查询条件
     * @return Page<CxApplyInfoVo>
     */
    Page<CxApplyInfoVo> findXkInfoPage(Long current, Long size, CxApplyInfoVo cxApplyInfoVo);

    /**
     * 查询统计一般案件总数
     * @param cxApplyInfoVo 查询条件
     * @return String
     */
    String countCaseNum(CxApplyInfoVo cxApplyInfoVo);

    /**
     * 执法人员个人首页查询许可办理中案件数量
     * @param sj sj 1 今年 2 本月
     * @param zfryid 执法人员id
     * @return
     */
    Integer queryBjQkXkBlIng(String sj, String zfryid);
    /**
     * 执法人员个人首页查询许可办结案件数量
     * @param sj sj 1 今年 2 本月
     * @param zfryid 执法人员id
     * @return
     */
    Integer queryBjQkXkBjEnd(String sj, String zfryid);

    /**
     * 查询统计案件数
     * @param cxApplyInfoVo 查询条件（机构、受案时间、结案时间）
     * @return CxApplyInfoVo
     */
    CxApplyInfoVo countXzspBjs(CxApplyInfoVo cxApplyInfoVo);
}
