package com.kdgcsoft.jt.xzzf.dubbo.xzsp.otherSys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqcltxzVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqxxVo;

import java.util.HashMap;
import java.util.List;

public interface InsidefaceService {
	
	/**
	 * 根据申请人获取事项
	 * @param form
	 * @return
	 */
	List<SqxxVo> getSqxxByRy(SqxxVo form);

	/**
	 * 根据申请人获取事项-分页查询
	 * @param current 当前页数
	 * @param size 每页行数
	 * @param form 查询参数
	 * @return
	 */
	Page<SqxxVo> getSqxxPageByRy(long current, long size, SqxxVo form);
	
	/**
	 * 查询超限凭证车辆信息by车牌号
	 * @param form 查询参数
	 * @return
	 */
	List<SqcltxzVo> getSqcltxzBycph(SqcltxzVo form);

	/**
	 * 查询超限凭证车辆信息by车牌号-分页查询
	 * @param current 当前页数
	 * @param size 每页行数
	 * @param form 查询参数
	 * @return
	 */
	Page<SqcltxzVo> getSqcltxzPageBycph(long current, long size, SqcltxzVo form);

	/**
	 * 获取许可决定书PDF记录
	 * @param sqxxid 申请信息ID
	 * @return
	 */
	HashMap<String, String> getJDSInfo(String sqxxid);

	/**
	 * 获取许可事项的详细信息和许可决定书PDF记录
	 * @param sqxxid 申请信息ID
	 * @return
	 */
	HashMap<String, SqxxVo> getJDSInfoByid(String sqxxid);
}
