package com.kdgcsoft.jt.xzzf.dubbo.xzsp.otherSys.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
* @Description: 评议审核对接行政审批接口实体类
* @Author: ln
* @Date: 2020/6/30
*/
@Data
public class CxApplyInfoVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 案件信息id
     */
    private String ajxxid;

    /**
     * 案号
     */
    private String ah;

    /**
     * 当事人名称
     */
    private String dsrmc;

    /**
     * 车船号
     */
    private String cch;

    /**
     * 案由
     */
    private String ay;

    /**
     * 受案时间
     */
    private String sasj;

    /**
     * 行政决定时间
     */
    private String xzjdsj;

    /**
     * 结案时间
     */
    private String jasj;

    /**
     * 执法机关
     */
    private String zfjg;

    /**
     * 执法机关id
     */
    private String zfjgid;

    /**
     * 处理人id
     */
    private String clrId;

    /**
     * 行业代码
     */
    private String hylbdm;

    /**
     * 受案时间起
     */
    private String sasjq;

    /**
     * 受案时间止
     */
    private String sasjz;

    /**
     * 状态
     */
    private String zt;

    /**
     * 年份
     */
    private String nf;

    /**
     * 受案机构id
     */
    private String sajgid;

    /**
     * 查询范围（为空查询当前以及子级；01查询当前机构；02查询当前机构子级。默认为空）
     */
    private String cxfw;

    /**
     * 时间类型 1-今年 2-本月 为空查询全部
     */
    private String timeFlag;

    /**
     * 结案日期开始范围
     */
    private String startJaTime;

    /**
     * 结案日期结束范围
     */
    private String endJaTime;

    /**
     * 结案日期开始范围
     */
    private String jasjq;

    /**
     * 结案日期结束范围
     */
    private String jasjz;

    private List<String> jgidList;
    

    private String orgCode;

    /**
     * 申请人证件号码
     */
    private String sqrzjhm;

    /**
     * 查询指标（1.一般案件 2.注销案件 3.案件有退回操作 4. 省级办理案件）
     */
    private String cxzb;

    /**
     * 办件状态数组
     */
    private String[] ztOpt;

    /**
     * 审批结果
     */
    private String spjg;

    /**
     * 02004 统一社会信用代码
     * 01001 身份证号码
     */
    private String dsrzjlxdm;

    /**
     * 当事人证件号码
     */
    private String dsrzjhm;

    /**
     * 预警风险点 （YJDJDM 01 提醒 02 预警 03 报警）
     */
    private String yjfxd;

    /**
     * 审批结果数组
     */
    private String[] spjgArr;

    /**
     * 风险点
     */
    private String fxd;

    /**
     * 风险点描述
     */
    private String fxdms;

    /**
     * 办理环节
     */
    private String blhj;

    /**
     * 办件数
     */
    private String bjsNum;

    /**
     * 结案数
     */
    private String jasNum;

    /**
     * 超期数
     */
    private String cqsNum;

    /**
     * 注销数
     */
    private String zxsNum;

    @Override
    public String getId() {
        return ajxxid;
    }

    @Override
    public void setId(String id) {
        this.ajxxid = id;
    }


}
