package com.kdgcsoft.jt.xzzf.dubbo.xzsp.laws.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.laws.entity.LegalBasisVo;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author linian
 * @since 2019-12-27
 */
public interface LegalBasisService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @return 执法依据信息
     */
    Page<LegalBasisVo> searchLegalBasisPage(long current, long size, LegalBasisVo legalBasisVo);

    /**
     * 分页查询执法依据信息(事项清单-执法依据选择页面-可选列表)
     * @param page 分页信息
     * @param flfgmc 法律法规名称
     * @param zfyjIdList 执法依据ID列表
     * @return LegalBasisVo 法律法规信息
     */
    IPage<LegalBasisVo> searchPageForSelect(IPage page, String flfgmc, List<String> zfyjIdList);

    /**
     * 分页查询执法依据信息(事项清单-执法依据选择页面-已选列表)
     * @param zfyjIdList 执法依据ID列表
     * @return LegalBasisVo 法律法规信息
     */
    List<LegalBasisVo> searchSelectedZFYJ(List<String> zfyjIdList);

    /**
     * 根据法律法规名称 查找对应的 法律法规ID
     * @param legalBasisVo 执法依据VO
     * @return String
     */
    String findLawId(LegalBasisVo legalBasisVo);

    /**
     * 添加执法依据信息
     * @param legalBasisVo 执法依据VO
     * @return int
     */
    int insertLegalBasisInfo(LegalBasisVo legalBasisVo);

    /**
     * 根据zfyjId 获取对应的执法依据信息
     * @param zfyjId 执法依据ID
     * @return LegalBasisVo 执法依据信息
     */
    LegalBasisVo getLegalBasisInfoById(String zfyjId);

    /**
     * 修改执法依据信息
     * @param legalBasisVo 执法依据VO
     * @return int
     */
    int updateLegalBasisiInfo(LegalBasisVo legalBasisVo);

    /**
     * 删除执法依据信息  将DELETE_FLAG 改为01 表示删除  00 表示未删除
     * @param legalBasisVo 执法依据VO
     * @return int
     */
    int deleteLegalBasis(LegalBasisVo legalBasisVo);

    /**
     * 获取事项关联的执法依据
     * @param sxxxId 事项清单id
     * @return
     */
    List<LegalBasisVo> getZFYJBySxxxId(String sxxxId);

    /**
     * 查询是否存在此条法律法规名称
     * @param flfgmc 法律法规名称
     * @return List<String>
     */
    List<String> findFlfgAll(String flfgmc);
}

