package com.kdgcsoft.jt.xzzf.dubbo.xzsp.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.entity.FjbVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.laws.entity.FlfgVO;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author zhaokai
 * @since 2019-12-27
 */
public interface FlfgService {

    /**
     * 修改信息
     * @param xtbaJFlfg
     * @return
     */
    boolean updateFlfgById(FlfgVO xtbaJFlfg);

    /**
     * 根据ID删除信息
     * @param id
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     * @param id
     * @return
     */
    FlfgVO getFlfgById(String id);

    /**
     * 自定义分页查询
     * @param current
     * @param size
     * @param xtbaJFlfg
     * @return
     */
    Page<FlfgVO> searchLawPage(long current, long size, FlfgVO xtbaJFlfg);

    /**
     * 法律法规Combobox
     * @return
     */
    List<FlfgVO> searchLawCombo();

    /**
     * 通过名称查找
     * @param flfgmc
     * @return
     */
    List<FlfgVO> getFlfgByName(String flfgmc);

    /**
     * 根据法律法规名称查找法律法规信息
     * @param flfgVO
     * @return
     */
    FlfgVO searcharFlfgInfo(FlfgVO flfgVO);

    /**
     * 根据关键字模糊查询法律法规名称
     * @param flfgmc
     * @return
     */
    List<FlfgVO> searchFlfgMc(String flfgmc);

    /**
     * 保存法律法规
     * @param xtbaJFlfg
     * @return
     */
    int insertFlfgById(FlfgVO xtbaJFlfg);

    /**
     * 判断法律法规是否重复
     * @param flfgmc
     * @return
     */
    List<FlfgVO> judge(String flfgmc);

    /**
     * 更新附件表
     * @param flfgVO
     * @return
     */
    Boolean updateByFjId(FlfgVO flfgVO);

    /**
     * 通过法律法规id获取附件信息
     * @param flfgid
     * @return
     */
    List<FjbVO> getFjLj(String flfgid);

    /**
     * 假删附件信息
     * @param fjbVO
     */
    Boolean deleteFjbById(FjbVO fjbVO);
}

