package com.kdgcsoft.jt.xzzf.dubbo.xzsp.laws.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhaokai
 * @since 2019-12-27
 */
@Data
@TableName("XTBA_J_FLFG")
public class FlfgVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 法律法规id
     */
    @TableId("FLFGID")
    private String flfgid;

    /**
     * 法律法规类别代码
     */
    private String flfglbdm;

    /**
     * 法律法规名称
     */
    private String flfgmc;

    /**
     * 制定机关
     */
    private String dzjg;

    /**
     * 发布机关
     */
    private String fbjg;

    /**
     * 发布文号
     */
    private String fbwh;

    /**
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fbrq;

    /**
     * 实施日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ssrq;

    /**
     * 实效性
     */
    private String sxx;

    /**
     * 失效日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sxrq;

    /**
     * 内容
     */
    private String nr;

    /**
     * 发布日期str
     */
    @TableField(exist = false)
    private String fbrqstr;

    /**
     *实施日期str
     */
    @TableField(exist = false)
    private String  ssrqstr;

    /**
     *更新时间str
     */
    @TableField(exist = false)
    private String  updatetimestr;

    /**
     *起始更新时间str
     */
    @TableField(exist = false)
    private String  updateDateStart;

    /**
     *结束更新时间str
     */
    @TableField(exist = false)
    private String  updateDateEnd;

    /**
     *起始发布时间str
     */
    @TableField(exist = false)
    private String  releaseDateStart;

    /**
     *结束发布时间str
     */
    @TableField(exist = false)
    private String  releaseDateEnd;

    /**
     * 前端字段
     */
    @TableField(exist = false)
    private String value;

    /**
     * 前台上传word名称
     * @return
     */
    @TableField(exist = false)
    private String wordmc;

    /**
     * 法律时效性  接受前端数据
     */
    @TableField(exist = false)
    private String[] lawSxx;

    /**
     * 附件id 从前台接收一个信息所包含的附件id
     */
    @TableField(exist = false)
    private String[] fjid;

    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr=new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr=new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr=new ArrayList();

    @Override
    public String getId() {
        return flfgid;
    }

    @Override
    public void setId(String id) {
        this.flfgid = id;
    }


}
