package com.kdgcsoft.jt.xzzf.dubbo.xzsp.historyData.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.*;

import java.util.List;

/**
 * 历史办件查询页面-service
 *
 * @author : 刘梦寻
 * @date : 2022-02-14 15:00
 **/
public interface HistoryQueryService {

    /**
     * 历史办件信息分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sqxxVo  查询参数
     * @return
     */
    Page<SqxxoldVo> page(long current, long size, SqxxoldVo sqxxVo);

    /**
     * 历史办件办件记录分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sqxxid  历史办件id
     * @return
     */
    Page<XzspJSpjloldVO> wfjlPage(long current, long size, String sqxxid);

    /**
     * 历史办件办件记录查询
     *
     * @param sqxxid  历史办件id
     * @return
     */
    List<XzspJSpjloldVO> wfjlList(String sqxxid);

    /**
     * 获取历史办件基础信息
     * @param sqxxid 历史办件id
     * @return
     */
    SqxxoldVo getHistoryInfo(String sqxxid);

    /**
     * 获取历史办件超限信息
     * @param sqxxid 历史办件id
     * @return
     */
    SqcxxxoldVo getHisBusinessInfo(String sqxxid);

    /**
     * 获取历史办件车辆信息
     * @param sqxxid 历史办件id
     * @return
     */
    SqclxxoldVo getHisCarInfo(String sqxxid);

    /**
     * 获取历史办件文书树
     * @param sqxxid 历史办件id
     * @return
     */
    List<DocTreeNode> getWenShuTree(String sqxxid);
}
