package com.kdgcsoft.jt.xzzf.dubbo.xzsp.govAffairs.service;


import com.kdgcsoft.jt.xzzf.dubbo.xzsp.govAffairs.entity.ResultBO;

/**
 * 行政审批-调取政务服务平台接口
 */
 public interface GovAffairsService {
    /**
     * 申报取号
     * @param sqxxId 申请信息Id
     * @param isAutoTask 是否来自自动任务
     */
    void apasRegInfo(String sqxxId, boolean isAutoTask) throws Exception;

    /**
    * 事项受理
    * @param sqxxId 申请信息Id
    * @param isAutoTask 是否来自自动任务
    */
    void accept(String sqxxId, boolean isAutoTask);

    /**
     * 补齐补正告知
     * @param sqxxId 申请信息Id
     * @param isAutoTask 是否来自自动任务
     */
    void patch(String sqxxId, boolean isAutoTask);

    /**
     * 办理
     * @param sqxxId 申请信息Id
     * @param isAutoTask 是否来自自动任务
     */
    void node(String sqxxId, boolean isAutoTask);

    /**
     * 挂起
     * @param sqxxId 申请信息Id
     * @param isAutoTask 是否来自自动任务
     */
    void hang(String sqxxId, boolean isAutoTask);

    /**
     * 解挂
     * @param sqxxId 申请信息Id
     * @param isAutoTask 是否来自自动任务
     */
    void hangRelease(String sqxxId, boolean isAutoTask);

    /**
     * 办结
     * @param sqxxId 申请信息Id
     * @param isAutoTask 是否来自自动任务
     */
    void transact(String sqxxId, boolean isAutoTask);
}
