package com.kdgcsoft.jt.xzzf.dubbo.xzsp.govAffairs.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * <p>
 * 政务服务-接口调取记录
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-04-29
 */
@Data
@TableName("XZSP_J_GOVLOG")
public class GovLogVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键-接口推送记录ID
     */
    private String govlogid;

    /**
     * 发送请求信息
     */
    private String requestInfo;

    /**
     * 响应返回信息
     */
    private String responseInfo;

    /**
     * 办件编码
     */
    private String bjbm;

    /**
     * 审批环节
     */
    private String sphj;

    /**
     * 上报结果标识：01成功/00失败
     */
    private String sendFlag;

    /**
     * 上报结果标识数组：01成功/00失败
     */
    @TableField(exist = false)
    private String[] sendFlagOpt;
   /**
     *创建开始时间
     */
    @TableField(exist = false)
    private String start;
    /**
     *创建结束时间
     */
    @TableField(exist = false)
    private String end;
    
    @Override
    public String getId() {
        return govlogid;
    }

    @Override
    public void setId(String id) {
        this.govlogid = id;
    }

}
