package com.kdgcsoft.jt.xzzf.dubbo.xzsp.flows.service;

import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDzqztp;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DocTreeNode;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.Requestparam;
import com.kdgcsoft.rdc.document.service.helper.JsonMsg;
import com.kdgcsoft.rdc.document.service.vo.PageRequestParam;

import java.util.List;
import java.util.Map;

/**
 * 申请信息文书树查询 service类
 * @Author: 刘梦寻
 * @Date: 2020/6/11
 */
public interface WenShuTreeService {

    /**
     * 获取许可案件相关文书树
     * @param requestparam 查询参数
     * @return
     */
    List<DocTreeNode> getTree(Requestparam requestparam);

    /**
     * 生成文书
     * @param requestParam 申请信息-模板信息
     * @param map 文书数据 MAP
     * @param isAddQRCode 是否添加二维码
     * @return
     */
    JsonMsg saveDocument(PageRequestParam requestParam, Map<String, Object> map, boolean isAddQRCode);

    /**
     * 删除文书
     * @param requestParam 申请信息-模板信息
     * @return
     */
    void deleteDocument(PageRequestParam requestParam);

    /**
     * 删除文书
     * @param requestParam 申请信息-模板信息
     * @param code 文书类型编码
     * @return
     */
    void deleteDocument(PageRequestParam requestParam, String code);

    /**
     * 获取PDF数据
     * @param var1 pdf记录Id
     * @return
     * @throws Exception
     */
    byte[] getPdfFile(String var1) throws Exception;

    /**
     * 向PDF写入数据
     * @param var1 pdf记录Id
     * @param var2 数据
     * @return
     * @throws Exception
     */
    boolean writePdfFile(String var1, byte[] var2) throws Exception;

    /**
     * 根据文书编码获取文书模板Id
     * @param code 文书类型编码
     * @return
     */
    String getWordTemplateIdByCode(String code);

    /**
     * 效验签章是否存在
     * @param sssxOrgId
     * @return
     */
    public SysDzqztp checkQz(String sssxOrgId, String type, SysUser sysUser) throws Exception;
}
