package com.kdgcsoft.jt.xzzf.dubbo.xzsp.document.service;


import com.kdgcsoft.jt.xzzf.dubbo.xzsp.document.entity.WstsjlVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqxxVo;

import java.util.List;

/**
 * 文书推送记录接口
 *
 * @author flm
 * @since 2020-08-27
 */
public interface WstsjlService {

    /**
     * 新增
     *
     * @param wstsjlVO
     * @return
     */
    boolean insert(WstsjlVO wstsjlVO);

    /**
     * 修改
     *
     * @param wstsjlVO
     * @return
     */
    boolean updateById(WstsjlVO wstsjlVO);

    /**
     * 根据ID删除
     *
     * @param id
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取
     *
     * @param id
     * @return
     */
    WstsjlVO getById(String id);


    /**
     * 分页查询
     *
     * @param wstsjlVO
     * @return
     */
    List<WstsjlVO> selectWstsjlPage(WstsjlVO wstsjlVO);

    /**
     * 根据当事人身份证号查询案件信息
     * @param wstsjlVO
     * @return
     */
    List<SqxxVo> searchSqxxForSqr(WstsjlVO wstsjlVO);

    /**
     * 根据当事人身份证号查询未查看文书数量
     * @param wstsjlVO
     * @return
     */
    int getSfydBySqr(WstsjlVO wstsjlVO);
}

