package com.kdgcsoft.jt.xzzf.dubbo.xzsp.djysdj.entity;

import lombok.Data;

import java.io.Serializable;

/**
 * 大件运输对接-待办列表返回实体类
 *
 * @author SL
 * @since 2020-08-31
 */
@Data
public class DblbfhVO implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 办件编号
     */
    private String projNo;

    /**
     * 办件名称
     */
    private String projName;

    /**
     * 申请人/申请单位
     */
    private String applyName;

    /**
     * 证件号码
     */
    private String applyCardNumber;

    /**
     * 申请时间
     * yyyyMMddHHmmss
     */
    private String applyTime;

    /**
     * 承诺时限 如10
     */
    private String cnqx;

    /**
     * 受理单位
     */
    private String acceptOrgName;

    /**
     * 受理时间
     * yyyyMMddHHmmss
     */
    private String acceptTime;

    /**
     * 当前环节
     */
    private String currentNodeName;

    /**
     * 应办结时间
     * yyyyMMddHHmmss
     */
    private String promiseEndtime;

    /**
     * 期限
     * -10 代表超时10工作日
     * 10 代表还剩10工作日
     */
    private String qx;

    /**
     * 办件来源
     */
    private String applyFromName;

    /**
     * 办理系统
     * 固定值djys
     */
    private String result;
}
