package com.kdgcsoft.jt.xzzf.dubbo.xzsp.constant;


import com.kdgcsoft.jt.xzzf.common.constant.DictConstants;
import org.springframework.beans.factory.annotation.Value;

/**
 * @Description: 字典常量类
 * @Author: zd
 * @Date: 2019/12/25
 */
public class DictConstant extends DictConstants {

    /**
     * 时效性
     */
    public static final String DICT_TIME_LINESS = "TIME_LINESS";

    /**
     * 证件类别
     */
    public static final String DICT_ZJLB = "ZJLB";

    /**
     * 案件来源
     */
    public static final String DICT_AJLY = "XKAJLY";

    /**
     * 案件来源
     */
    public static final String DICT_KYCL = "KYZT";

    /**
     * 送达文书送达方式
     */
    public static final String DICT_SDFS = "SDFSDM";

    /**
     * 预警等级
     */
    public static final String DICT_YJDJ = "YJDJDM";

    /**
     * 法律法规类别
     */
    public static final String DICT_LAWS_TYPE = "FLFGLBDM";

    /**
     * 执法依据类型
     */
    public static final String DICT_ZFYJLXDM = "ZFYJLXDM";

    /**
     * 是否启用代码
     */
    public static final String DICT_CODE_SFQY = "SFQY";

    /**
     * 启用
     */
    public static final String DICT_VALUE_QIYONG = "1";

    /**
     * 禁用
     */
    public static final String DICT_VALUE_JINYONG = "0";

    /**
     * 预警等级代码
     */
    public static final String DICT_CODE_YJDJDM = "YJDJDM";
    /**
     * 提醒类型代码
     */
    public static final String DICT_CODE_TSLXDM = "TSLXDM";

    /**
     * 预警调用算法
     */
    public static final String DICT_CODE_YJDYSF = "YJDYSF";

    /**
     * 行政审批办件类型代码
     */
    public static final String DICT_CODE_XZSPBJLXDM = "XZSPBJLXDM";

    /**
     * 行政审批行使层级代码
     */
    public static final String DICT_CODE_XSCJ = "XSCJ";

    /**
     * 事项类型代码
     */
    public static final String DICT_CODE_SXLXDM = "SXLXDM";

    /**
     * 事项匹配状态
     */
    public static final String DICT_CODE_SXPPZT = "SXPPZT";

    /**
     * 事项主状态代码
     */
    public static final String DICT_CODE_SXZZTDM = "SXZZTDM";

    /**
     * 事项状态代码
     */
    public static final String DICT_CODE_SXZTDM = "XZSPSXZTDM";

    /**
     * 事项状态代码-在用
     */
    public static final String DICT_CODE_SXZTDM_USE = "USE";

    /**
     * 事项状态代码-停用
     */
    public static final String DICT_CODE_SXZTDM_STOP = "STOP";

    /**
     * 事项状态代码-待启用
     */
    public static final String DICT_CODE_SXZTDM_TODO = "TODO";

    /**
     * 必要性代码
     */
    public static final String DICT_CODE_BYXDM = "BYXDM";

    /**
     * 来源渠道代码
     */
    public static final String DICT_CODE_LYQDDM = "LYQDDM";

    /**
     * 时限单位代码
     */
    public static final String DICT_CODE_SXDWDM = "SXDWDM";

    /**
     * 行业代码
     */
    public static final String DICT_CODE_HYDM = "XZSP_HYDM";

    /**
     * 行业
     */
    public static final String DICT_HANGYE = "HANGYE";

    /**
     * 企业类型代码
     */
    public static final String DICT_CODE_QYLXDM = "QYLXDM";

    /**
     * 企业经济类型代码
     */
    public static final String DICT_CODE_QYJYLXDM = "QYJYLXDM";

    /**
     * 业户类别代码
     */
    public static final String DICT_CODE_XZSPYHLBDM = "XZSP_YHLBDM";

    /**
     * 业户状态代码
     */
    public static final String DICT_CODE_YHZTDM = "YHZTDM";

    /**
     * 行政审批回函状态
     */
    public static final String DICT_CODE_XZSPHHZT = "XZSPHHZT";

    /**
     * 行政审批通行情况
     */
    public static final String DICT_CODE_XZSPTXQK = "XZSPTXQK";

    /**
     * 网约车许可申请 受理状态代码
     */
    public static final String DICT_CODE_SLZTDM = "SLZTDM";

    /**
     * 车牌颜色
     */
    public static final String DICT_CODE_XZSPCPYS = "XZSPCPYS";

    /**
     * 环节类别编码-超限运输车辆类型
     */
    public static final String DICT_CODE_CXYSCLLX = "CXYSCLLX";

    /**
     * 注销状态
     */
    public static final String DICT_SFZX = "SFZX";

    /**
     * 通行次数
     */
    public static final String DICT_CODE_TXCS = "XZSP_TXCS";

    /**
     * 通行次数-多次通行
     */
    public static final String DICT_VALUE_TXCS_DCTX = "2";

    /**
     * 跨省申请状态
     */
    public static final String DICT_CODE_REQUEST_STATUS = "REQUEST_STATUS";

    /**
     * 资质等级代码
     */
    public static final String DICT_CODE_ZZDJDM = "ZZDJDM";

    /**
     * 信誉等级代码
     */
    public static final String DICT_CODE_XYDJDM = "XYDJDM";

    /**
     * 环节名称
     */
    public static final String DICT_CODE_HJMC = "XZSP_HJMC";

    /**
     * 通行能力审批状态-未审批
     */
    public static final String DICT_CODE_TXNLSPZT = "XZSP_TXNLSPZT";

    /**
     * 通行能力审批状态-审批同意
     */
    public static final String DICT_VALUE_TXNLSPZT_WSP = "00";

    /**
     * 通行能力审批状态-准予许可
     */
    public static final String DICT_VALUE_TXNLSPZT_ZYXK = "01";

    /**
     * 通行能力审批状态-不予许可
     */
    public static final String DICT_VALUE_TXNLSPZT_BYXK = "02";

    /**
     * 使用范围-本单位代码
     */
    public static final String DICT_CODE_SYFW_BDW = "1";

    /**
     * 使用范围-多个单位代码
     */
    public static final String DICT_CODE_SYFW_DGDW = "2";

    /**
     * 常用意见类型-公有
     */
    public static final String DICT_VALUE_CYYJLX_GY = "01";

    /**
     * 常用意见类型-私有
     */
    public static final String DICT_VALUE_CYYJLX_SY = "02";

    /**
     * 案件来源
     */
    public static final String DICT_CODE_XKAJLY = "XKAJLY";

    /**
     * 案件来源-窗口申请
     */
    public static final String DICT_VALUE_AJLY_CKSQ = "01";

    /**
     * 案件来源-大件运输
     */
    public static final String DICT_VALUE_AJLY_DJYS = "02";

    /**
     * 案件来源-政务网
     */
    public static final String DICT_VALUE_AJLY_ZWW = "03";

    /**
     * 案件来源-网约车
     */
    public static final String DICT_VALUE_AJLY_WYC = "04";

    /**
     * 申请信息状态-办理中
     */
    public static final String DICT_VALUE_SQXXZT_BLZ = "01";

    /**
     * 申请信息状态-未归档
     */
    public static final String DICT_VALUE_SQXXZT_WGD = "02";

    /**
     * 申请信息状态-已归档
     */
    public static final String DICT_VALUE_SQXXZT_YGD = "03";

    /**
     * 时限单位代码-工作日
     */
    public static final String DICT_VALUE_SXDWDM_D = "D";

    /**
     * 时限单位代码-小时
     */
    public static final String DICT_VALUE_SXDWDM_H = "H";

    /**
     * 时限单位代码-分钟
     */
    public static final String DICT_VALUE_SXDWDM_M = "M";

    /**
     * 材料类别-纸质
     */
    public static final String DICT_CODE_CLLB = "XZSP_CLLB";

    /**
     * 材料类别-纸质
     */
    public static final String DICT_VALUE_CLLB_ZZ = "01";

    /**
     * 材料类别-纸质
     */
    public static final String DICT_VALUE_CLLB_DZ = "02";

    /**
     * 保存方式  新增
     */
    public static final String DICT_VALUE_SAVEFLAG_1 = "insert";

    /**
     * 保存方式  修改
     */
    public static final String DICT_VALUE_SAVEFLAG_2 = "UPDATE";

    /**
     * 待办页面-待办列表表头字段
     */
    public static final String DICT_CODE_DBLBBT = "sqr,sqsx,sqrq,cbbjri,hjmc,hjsysx,ajlymc";

    /**
     * 待办页面-可编辑的类型
     * 政务网办件-运管许可-可编辑申请信息
     */
    public static final String DICT_VALUE_DBYMBJLX_1 = "01";

    /**
     * 待办页面-可编辑的类型
     * 政务网办件-超限许可-可编辑业务表单
     */
    public static final String DICT_VALUE_DBYMBJLX_2 = "02";

    /**
     * 待办页面-可编辑的类型
     * 跨省超限办件-可编辑申请信息
     */
    public static final String DICT_VALUE_DBYMBJLX_3 = "03";

    /**
     * 待办页面-可编辑的类型
     * 省内超限办件-初审、复审、终审环节可编辑业务表单信息；市内超限-受理环节可编辑业务表单信息
     */
    public static final String DICT_VALUE_DBYMBJLX_4 = "04";

    /**
     * 许可结果-准予许可
     */
    public static final String DICT_CODE_XKJG = "XZSPXKJG";

    /**
     * 许可结果-准予许可
     */
    public static final String DICT_VALUE_XKJG_XK = "01";

    /**
     * 许可结果-不予许可
     */
    public static final String DICT_VALUE_XKJG_BYXK = "02";

    /**
     * 办理结果-批准办结
     */
    public static final String DICT_VALUE_BLJG_PZBJ = "0501";

    /**
     * 办理结果-作废办结
     */
    public static final String DICT_VALUE_BLJG_ZFBJ = "0503";

    /**
     * 省内超限大件运输申请状态-受理
     */
    public static final String DICT_VALUE_SNCXSQZT_SL = "12";

    /**
     * 省内超限大件运输申请状态-退回补正
     */
    public static final String DICT_VALUE_SNCXSQZT_THBZ = "13";

    /**
     * 大件运输类型代码-起运省
     */
    public static final String DICT_VALUE_DJYSLXDM_QYS = "01";

    /**
     * 大件运输类型代码-沿线省
     */
    public static final String DICT_VALUE_DJYSLXDM_YXS = "02";

    /**
     * 大件运输类型代码-延期-起运省
     */
    public static final String DICT_VALUE_DJYSLXDM_YQQYS = "03";

    /**
     * 大件运输类型代码-延期-沿线省
     */
    public static final String DICT_VALUE_DJYSLXDM_YQYXS = "04";

    /**
     * 勘验状态代码-未勘验
     */
    public static final String DICT_VALUE_KYCLDM_WKY = "0";

    /**
     * 勘验状态代码-勘验不通过
     */
    public static final String DICT_VALUE_KYCLDM_KYBTG = "3";

    /**
     * 车辆类型-货车
     */
    public static final String DICT_VALUE_CLLX_HC = "20";

    /**
     * 车辆类型-牵引车
     */
    public static final String DICT_VALUE_CLLX_QYC = "36";

    /**
     * 车辆类型-挂车1
     */
    public static final String DICT_VALUE_CLLX_GC1 = "37";

    /**
     * 车辆类型-挂车2
     */
    public static final String DICT_VALUE_CLLX_GC2 = "38";

    /**
     * 是
     */
    public static final String DICT_VALUE_YES = "1";

    /**
     * 否
     */
    public static final String DICT_VALUE_NO = "0";

    /**
     * 是否政务对接-需要对接
     */
    public static final String DICT_VALUE_SFZWDJ_YES = "00";

    /**
     * 是否政务对接-无需对接
     */
    public static final String DICT_VALUE_SFZWDJ_NO = "01";

    /**
     * 是否政务对接-与讯飞对接
     */
    public static final String DICT_VALUE_SFZWDJ_XF = "02";

    /**
     * 许可决定书类型-许可决定书
     */
    public static final String DICT_VALUE_XKJDSLX_XK = "01";

    /**
     * 许可决定书类型-变更决定书
     */
    public static final String DICT_VALUE_XKJDSLX_BG = "02";

    /**
     * 许可决定书类型-延续决定书
     */
    public static final String DICT_VALUE_XKJDSLX_YX = "03";

    /**
     * 证件类型代码
     */
    public static final String DICT_CODE_ZJLXDM = "XZSP_SQRZJLXDM";

    /**
     * 证件类型-身份证
     */
    public static final String DICT_VALUE_ZJLX_SFZ = "01001";

    /**
     * 证件类型-统一社会信用代码
     */
    public static final String DICT_VALUE_ZJLX_TYSHXYDM = "02004";

    /**
     * 特殊情况签注代码
     */
    public static final String DICT_CODE_TSQKQZDM = "XZSP_TSQKQZDM";

    /**
     * 协调不通过原因/修改路线原因代码
     */
    public static final String DICT_CODE_XZSPXGLXYY = "XZSPXGLXYY";

    /**
     * 上报政务网-结果状态-成功
     */
    public static final String DICT_VALUE_SBZWFW_STATUS_SUCCESS = "01";

    /**
     * 上报政务网-结果状态-失败
     */
    public static final String DICT_VALUE_SBZWFW_STATUS_FAIL = "00";

    /**
     * 上报政务网-环节名称-受理
     */
    public static final String DICT_VALUE_SBZWFW_NODE_SL = "SL";

    /**
     * 上报政务网-环节名称-办理
     */
    public static final String DICT_VALUE_SBZWFW_NODE_BL = "BL";

    /**
     * 上报政务网-环节名称-挂起
     */
    public static final String DICT_VALUE_SBZWFW_NODE_GQ = "GQ";

    /**
     * 上报政务网-环节名称-解挂
     */
    public static final String DICT_VALUE_SBZWFW_NODE_JG = "JG";

    /**
     * 上报政务网-环节名称-办结
     */
    public static final String DICT_VALUE_SBZWFW_NODE_BJ = "BJ";

    /**
     * 业户状态-营业
     */
    public static final String DICT_VALUE_YHZT_YY = "1";

    /**
     * 案件类型-一般类型
     */
    public static final String DICT_VALUE_AJLX_NORMAL = "1";

    /**
     * 案件类型-港航案件
     */
    public static final String DICT_VALUE_AJLX_GH = "2";

    /**
     * 签字状态
     */
    public static final String DICT_CODE_XZSP_QZZT = "XZSP_QZZT";
    /**
     * 签字状态-已签字-01
     */
    public static final String DICT_CODE_QZZT_VALUE_01 = "01";
    /**
     * 签字状态-未签字-02
     */
    public static final String DICT_CODE_QZZT_VALUE_02 = "02";
    /**
     * 短信模板编码，环节短信
     */
    public static final String MSG_CODE_HJ = "01";
    /**
     * 短信模板编码，超限案件-发短信提醒申请人在APP查看通行证
     */
    public static final String MSG_CODE_CX = "02";
    /**
     * 短信模板编码，超限发函短信
     */
    public static final String MSG_CODE_CXFH = "03";

    /**
     * 短信模板编码，运管发函短信
     */
    public static final String MSG_CODE_YGFH = "04";
    /**
     * 短信模板编码，大件运输评价退回
     */
    public static final String MSG_CODE_PJTH = "05";
    /**
     * 短信模板编码，勘验不通过给申请人发短信
     */
    public static final String MSG_CODE_KYBTG = "06";
    /**
     * 卷宗目录列表
     */
    public static final String DICT_XZSP_JZMLLB = "XZSP_JZMLLB";
    /**
     * 大件运输评价等级
     */
    public static final String DICT_XZSP_PJDJ = "XZSP_PJDJ";
    /**
     * 大件运输评价等级
     */
    public static final String DICT_XZSP_CPLX = "XZSP_CPLX";
    /**
     * 大件运输评价依据
     */
    public static final String DICT_XZSP_PJYJ = "XZSP_PJYJ";
    /**
     * 大件运输评价状态
     */
    public static final String DICT_XZSP_DJPJZT = "XZSP_DJPJZT";
    /**
     * 大件运输评价操作类型
     */
    public static final String DICT_XZSP_CZLX = "XZSP_CZLX";
    /**
     * 大件运输评价--状态-待核实
     */
    public static final String DICT_CODE_XZSP_DJPJZT_01 = "1";
    /**
     * 大件运输评价--状态-待反馈
     */
    public static final String DICT_CODE_XZSP_DJPJZT_02 = "2";
    /**
     * 大件运输评价--状态-待处理反馈
     */
    public static final String DICT_CODE_XZSP_DJPJZT_03 = "3";
    /**
     * 大件运输评价--状态-待确认
     */
    public static final String DICT_CODE_XZSP_DJPJZT_04 = "4";
    /**
     * 大件运输评价--状态-已反馈
     */
    public static final String DICT_CODE_XZSP_DJPJZT_05 = "5";
    /**
     * 文书修改申请-状态-待处理
     */
    public static final String DICT_CODE_WSXG_TOHANDLE = "0";
    /**
     * 文书修改申请-状态-待处理
     */
    public static final String DICT_CODE_WSXG_PASS = "1";
    /**
     * 文书修改申请-状态-待处理
     */
    public static final String DICT_CODE_WSXG_NOT_PASS = "2";

    ////////////////////////////////////  文书编码   ////////////////////////////////////
    /**
     * 文书编码-许可申请书编码
     */
    public static final String DICT_VALUE_DOC_XKSQS = "XZSP_D_XKSQS";

    /**
     * 文书编码-授权委托书
     */
    public static final String DICT_VALUE_DOC_SQWTS = "XZSP_D_SQWTS";

    /**
     * 文书编码-准予许可决定书编码
     */
    public static final String DICT_VALUE_DOC_XKJDS = "XZSP_D_XKJDS";

    /**
     * 文书编码-不予许可决定书编码
     */
    public static final String DICT_VALUE_DOC_BYXKJDS = "XZSP_D_BYXKJDS";

    /**
     * 文书编码-准予变更决定书编码
     */
    public static final String DICT_VALUE_DOC_ZYBGJDS = "XZSP_D_ZYBGJDS";

    /**
     * 文书编码-道路客运经营行政许可决定书编码
     */
    public static final String DICT_VALUE_DOC_DLKYJYXZXKJDS = "XZSP_D_DLKYJYXZXKJDS";

    /**
     * 文书编码-道路客运班线经营行政许可决定书编码
     */
    public static final String DICT_VALUE_DOC_DLKYBXJYXZXKJDS = "XZSP_D_DLKYBXJYXZXKJDS";

    /**
     * 文书编码-不予变更决定书编码
     */
    public static final String DICT_VALUE_DOC_BYBGJDS = "XZSP_D_BYBGJDS";

    /**
     * 文书编码-准予延续决定书编码
     */
    public static final String DICT_VALUE_DOC_ZYYXJDS = "XZSP_D_ZYYXJDS";

    /**
     * 文书编码-不予延续决定书编码
     */
    public static final String DICT_VALUE_DOC_BYYXJDS = "XZSP_D_BYYXJDS";

    /**
     * 文书编码-申请受理通知书
     */
    public static final String DICT_VALUE_DOC_SQSLTZS = "XZSP_D_SQSLTZS";

    /**
     * 文书编码-许可材料接收凭证
     */
    public static final String DICT_VALUE_DOC_CLJSPZ = "XZSP_D_CLJSPZ";

    /**
     * 文书编码-交通行政许可核查笔录
     */
    public static final String DICT_VALUE_DOC_HCBL = "XZSP_D_HCBL";

    /**
     * 文书编码-交通行政许可事项核查意见书
     */
    public static final String DICT_VALUE_DOC_HCYJS = "XZSP_D_HCYJS";

    /**
     * 文书编码-不予受理决定书
     */
    public static final String DICT_VALUE_DOC_BYSLJDS = "XZSP_D_BYSLJDS";

    /**
     * 文书编码-许可受理审查意见书
     */
    public static final String DICT_VALUE_DOC_SLSCJYS = "XZSP_D_SLSCJYS";

    /**
     * 文书编码-许可送达文书编码
     */
    public static final String DICT_VALUE_DOC_WSSDHZ = "XZSP_D_WSSDHZ";

    /**
     * 文书编码-许可审查意见书
     */
    public static final String DICT_VALUE_DOC_SCYJS = "XZSP_D_SCYJS";

    /**
     * 文书编码-即办审查意见书
     */
    public static final String DICT_VALUE_DOC_JBSCYJS = "XZSP_D_JBJSCYJS";

    /**
     * 文书编码-省公路审查意见书
     */
    public static final String DICT_VALUE_DOC_SGLSCYJS = "XZSP_D_SGLSCYJS";

    /**
     * 文书编码-道路客运审查意见书
     */
    public static final String DICT_VALUE_DOC_DLKYSCYJS = "XZSP_D_DLKYSCYJS";

    /**
     * 文书编码-超限车辆通行证
     */
    public static final String DICT_VALUE_DOC_TXZ = "XZSP_D_TXZ";

    /**
     * 文书编码-卷宗
     */
    public static final String DICT_VALUE_DOC_JZ = "XZSP_D_JZ";

    /**
     * 文书编码-卷宗目录
     */
    public static final String DICT_VALUE_DOC_JZML = "XZSP_D_JZML";

    /**
     * 文书编码-备考表
     */
    public static final String DICT_VALUE_DOC_BKB = "XZSP_D_BKB";

    /**
     * 交通行政许可不予变更决定书
     */
    public static final String DICT_CODE_XZSP_BYBGJDS = "7e66119f-44c2-4480-9ca7-a97b05afc199";

    /**
     * 交通运输行政许可申请不予受理决定书
     */
    public static final String DICT_CODE_XZSP_BYSLJDS = "6c101285-6453-4cde-bba6-a07aebe9f52b";

    /**
     * 交通行政许可不予延续决定书
     */
    public static final String DICT_CODE_XZSP_BYYXJDS = "e2683a53-4b72-4c56-aab6-86ab26216d1d";

    /**
     * 不予交通运输行政许可决定书
     */
    public static final String DICT_CODE_XZSP_BYXKJDS = "2503c2b5-d1e0-4bf6-acc4-898fa93b9edc";

    /**
     * 交通运输行政许可决定书
     */
    public static final String DICT_CODE_XZSP_XKJDS = "47706fae-3808-4bc7-a8c6-b4ea430907c0";

    /**
     * 交通行政许可准予变更决定书
     */
    public static final String DICT_CODE_XZSP_ZYBGJDS = "a3ff6c23-1660-4ac9-bdee-0aa2c222a787";

    /**
     * 交通行政许可准予延续决定书
     */
    public static final String DICT_CODE_XZSP_ZYYXJDS = "82fe6fc0-f2ca-43c1-a0ee-8935a4727290";

    /**
     * 道路客运班线经营行政许可决定书
     */
    public static final String DICT_CODE_XZSP_DLKYBXJYXZXKJDS = "1a41a56e-7fde-48f8-8172-d5224e3e392a";

    /**
     * 道路客运经营行政许可决定书
     */
    public static final String DICT_CODE_XZSP_DLKYJYXZXKJDS = "31857f84-aa12-49fa-bace-421a7adf2b5c";

    /**
     * 超限运输车辆通行证
     */
    public static final String DICT_CODE_XZSP_CXTXZ = "ddcea42a-7c3c-4907-8d92-8993a6f168dd";

    /**
     * 超限征询发函
     */
    public static final String DICT_CODE_XZSP_CXZXFH = "c701fa6d-6b3b-441a-ad6b-5c98ab695e2c";

    /**
     * 超限征询回函
     */
    public static final String DICT_CODE_XZSP_CXZXHH = "687e2401-ad05-4464-b82e-c6e659b8c3b9";

    /**
     * 运管征询发函
     */
    public static final String DICT_CODE_XZSP_YGZXFH = "33fd75b6-75eb-42d7-be95-6c6b8a2bb3df";

    /**
     * 运管征询回函
     */
    public static final String DICT_CODE_XZSP_YGZXHH = "92b4b173-6249-473c-b902-ad9d38274650";

    /**
     * 勘验报告
     */
    public static final String DICT_CODE_XZSP_KYBG = "e7d5fb4c-e55a-4702-b8e1-644c83ceb1c0";

    /**
     * 航道工程竣工验收证书WordTemplateId
     */
    public static final String DICT_CODE_XZSP_HDGCJGYSZS = "9c39b3f8-686a-4f24-a4c4-54918f495d1b";

    /**
     * 文书卷宗WordTemplateId
     */
    public static final String DICT_CODE_XZSP_JZ = "df582f3a-4866-487e-81a6-48d283992934";

    /**
     * 文书卷宗目录WordTemplateId
     */
    public static final String DICT_CODE_XZSP_JZML = "4dc0962c-42e2-4fdd-adde-55349f7ceddd";

    /**
     * 文书备考表WordTemplateId
     */
    public static final String DICT_CODE_XZSP_BKB = "f3736d57-7649-4a5d-b493-94da20b1c0bb";

    ////////////////////////////////////  环节类别编码   ////////////////////////////////////
    /**
     * 环节类别编码-制作许可决定书环节
     */
    public static final String DICT_CODE_HJLB = "HJLB";

    /**
     * 环节类别编码-分发环节
     */
    public static final String DICT_VALUE_HJLB_FF = "FF";

    /**
     * 环节类别编码-受理环节
     */
    public static final String DICT_VALUE_HJLB_SL = "SL";

    /**
     * 环节类别编码-超限受理
     */
    public static final String DICT_VALUE_HJLB_CXSL = "CXSL";

    /**
     * 环节类别编码-客运受理
     */
    public static final String DICT_VALUE_HJLB_KYSL = "KYSL";

    /**
     * 环节类别编码-初审
     */
    public static final String DICT_VALUE_HJLB_CS = "CS";

    /**
     * 环节类别编码-客运初审
     */
    public static final String DICT_VALUE_HJLB_KYCS = "KYCS";

    /**
     * 环节类别编码-复审
     */
    public static final String DICT_VALUE_HJLB_FS = "FS";

    /**
     * 环节类别编码-终审
     */
    public static final String DICT_VALUE_HJLB_ZS = "ZS";

    /**
     * 环节类别编码-制作许可决定书环节
     */
    public static final String DICT_VALUE_HJLB_XK = "XK";

    /**
     * 环节类别编码-制作不予许可决定书环节
     */
    public static final String DICT_VALUE_HJLB_BYXK = "BYXK";

    /**
     * 环节类别编码-等待
     */
    public static final String DICT_VALUE_HJLB_DD = "DD";

    /**
     * 环节类别编码-交警审核
     */
    public static final String DICT_VALUE_HJLB_JJSH = "JJSH";

    /**
     * 环节类别编码-协调路线
     */
    public static final String DICT_VALUE_HJLB_XTLX = "XTLX";

    /**
     * 环节类别编码-决定打证
     */
    public static final String DICT_VALUE_HJLB_JDDZ = "JDDZ";

    /**
     * 环节类别编码-送达
     */
    public static final String DICT_VALUE_HJLB_SD = "SD";

    /**
     * 环节类别编码-挂起
     */
    public static final String DICT_VALUE_HJLB_GQ = "GQ";

////////////////////////////////////  工作流分支optCode   ////////////////////////////////////
    /**
     * 工作流分支optCode
     */
    public static final String DICT_CODE_OPTCODE = "XZSP_WFCZBM";

    /**
     * 工作流分支optCode-不予受理、补齐补正
     */
    public static final String DICT_CODE_OPTCODE_BSLBQBZ = "BSLBQBZ";

    /**
     * 工作流分支optCode-受理
     */
    public static final String DICT_CODE_OPTCODE_SL = "SL";

    /**
     * 工作流分支optCode-不予受理
     */
    public static final String DICT_CODE_OPTCODE_BSL = "BSL";

    /**
     * 工作流分支optCode-补齐补正
     */
    public static final String DICT_CODE_OPTCODE_BQBZ = "BQBZ";

    /**
     * 工作流分支optCode-挂起
     */
    public static final String DICT_CODE_OPTCODE_GQ = "GQ";

    /**
     * 工作流分支optCode-准予许可
     */
    public static final String DICT_CODE_OPTCODE_XK = "XK";

    /**
     * 工作流分支optCode-不予许可
     */
    public static final String DICT_CODE_OPTCODE_BYXK = "BYXK";

    /**
     * 工作流分支optCode-协调路线
     */
    public static final String DICT_CODE_OPTCODE_XTLX = "XTLX";

    /**
     * 工作流分支optCode-退回
     */
    public static final String DICT_CODE_OPTCODE_TH = "TH";

    /**
     * 工作流分支optCode-退回初审
     */
    public static final String DICT_CODE_OPTCODE_THCS = "THCS";

    /**
     * 工作流分支optCode-退回复审
     */
    public static final String DICT_CODE_OPTCODE_THFS = "THFS";

    /**
     * 工作流分支optCode-退回终审
     */
    public static final String DICT_CODE_OPTCODE_THZS = "THZS";

    /**
     * 工作流分支optCode-提交终审
     */
    public static final String DICT_CODE_OPTCODE_TJZS = "TJZS";

    /**
     * 工作流分支optCode-主分支
     */
    public static final String DICT_CODE_OPTCODE_ZFZ = "ZFZ";

    /**
     * 工作流分支optCode-结束
     */
    public static final String DICT_CODE_OPTCODE_JS = "JS";

    /**
     * 工作流分支optCode-同意（超限1、2件）、直接到等待
     */
    public static final String DICT_CODE_OPTCODE_DD = "DD";

////////////////////////////////////  流程编码   ////////////////////////////////////

    /**
     * 流程编码-省级涉路许可
     */
    public static final String DICT_VALUE_LCBM_SJSLXK = "SJSLXK";

    /**
     * 流程编码-跨省大件
     */
    public static final String DICT_VALUE_LCBM_KSDJQYS = "KSDJ-QYS";

    /**
     * 流程编码-省内跨市区超限流程
     */
    public static final String DICT_VALUE_LCBM_SNKSQCXLC = "SNKSQCXLC";

////////////////////////////////////  页面地址相关   ////////////////////////////////////
    /**
     * 页面类型-归档页面
     */
    public static final String DICT_VALUE_YMLX_GD = "gd";

    /**
     * 页面类型-待办页面
     */
    public static final String DICT_VALUE_YMLX_DB = "db";

    /**
     * 页面类型-查询页面
     */
    public static final String DICT_VALUE_YMLX_CX = "cx";

    /**
     * 页面地址-运管许可登记页面
     */
    public static final String DICT_VALUE_YMDZ_YGDJ = "/xkbl/bjdj/djym";

    /**
     * 页面地址-超限许可登记页面
     */
    public static final String DICT_VALUE_YMDZ_CXDJ = "/xkbl/bjdj/cxdjym";

    /**
     * 页面地址-归档详细页面
     */
    public static final String DICT_VALUE_YMDZ_GDXX = "xkbl/xkblGdPage.html";

    /**
     * 页面地址-申请详细页面
     */
    public static final String DICT_VALUE_YMDZ_SPXX = "xkbl/xkblPage.html";

    /**
     * 页面地址-许可代办列表页面
     */
    public static final String DICT_VALUE_YMDZ_XKDB = "/xkbl/daiBan/daiBanList.html";

    /**
     * 页面地址-申请详细页面-审批意见部分-待办
     */
    public static final String DICT_VALUE_YMDZ_SPYJ = "/xkbl/daiBan/daiBanPageContent.html";

    /**
     * 页面地址-申请详细页面-按钮部分-待办
     */
    public static final String DICT_VALUE_YMDZ_HANDLEBTN = "/xkbl/daiBan/daiBanPageButton.html";

    /**
     * 页面地址-申请详细页面-按钮部分-查看
     */
    public static final String DICT_VALUE_YMDZ_VIEWBTN = "/xkbl/daiBan/operater/viewButton.html";

    /**
     * 页面地址-申请详细页面-审批意见部分-空页面
     */
    public static final String DICT_VALUE_YMDZ_SPYJNULL = "/xkbl/daiBan/operater/blankContent.html";

    /**
     * 页面地址-实施事项管理页面-批量复制事项办理人员页面
     */
    public static final String DICT_VALUE_YMDZ_PLFZSXBLRY = "basicDataManage/sssxgl/multiCopyPeople.html";

    ////////////////////////////////////  事项ID、编码相关字典值   ////////////////////////////////////
    /**
     * 跨省超限事项_3 实施事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起超过4.5米，或者总宽度超过3.75米，
     * 或者总长度超过28米，或者总质量超过100000千克的)
     */
    public static final String DICT_CODE_KSCXSX_3 = "2d42b3d748b242779bd7edc344f8a7bc";

    /**
     * 跨省超限事项_2 实施事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.5米，
     * 或者总宽度未超过3.75米，或者总长度未超过28米，或者总质量未超过100000千克的)
     */
    public static final String DICT_CODE_KSCXSX_2 = "5eaee1acbbe746ec9d45e187bf3f16db";

    /**
     * 跨省超限事项_1 实施事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.2米，或者总宽度未超过3米，或者总长度未超过20米，
     * 且车货总质量、轴荷未超过《超限运输车辆行驶公路管理规定》第三条、第十七条规定标准的)
     */
    public static final String DICT_CODE_KSCXSX_1 = "8974a0b210f14559ae03f32cc82b2e0e";

    /**
     * 跨省超限事项_3 事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起超过4.5米，或者总宽度超过3.75米，
     * 或者总长度超过28米，或者总质量超过100000千克的)
     */
    public static final String DICT_CODE_SXBM_KSCXSX_3 = "27589e22aefd4cc0ab88ce4abb01b8a6";

    /**
     * 跨省超限事项_2 事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.5米，
     * 或者总宽度未超过3.75米，或者总长度未超过28米，或者总质量未超过100000千克的)
     */
    public static final String DICT_CODE_SXBM_KSCXSX_2 = "eba5f9b7e0a74ab8b3fce96c29354aa2";

    /**
     * 跨省超限事项_1 事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.2米，或者总宽度未超过3米，或者总长度未超过20米，
     * 且车货总质量、轴荷未超过《超限运输车辆行驶公路管理规定》第三条、第十七条规定标准的)
     */
    public static final String DICT_CODE_SXBM_KSCXSX_1 = "886743f3929e44df90ec418d082127f0";

    /**
     * 省内跨市超限事项_1 实施事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起超过4.5米，
     * 或者总宽度超过3.75米，或者总长度超过28米，或者总质量超过100000千克的)
     */
    public static final String DICT_CODE_SNCXSX_1 = "8b9826cf8e9f43498040ec393355a534";

    /**
     * 省内跨市超限事项_2 实施事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.5米，
     * 或者总宽度未超过3.75米，或者总长度未超过28米，或者总质量未超过100000千克的)
     */
    public static final String DICT_CODE_SNCXSX_2 = "33685ba18a6a4a31ab3d7188bbd01135";

    /**
     * 省内跨市超限事项_3 实施事项编码
     * 省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.2米，或者总宽度未超过3米，或者总长度未超过20米，
     * 且车货总质量、轴荷未超过《超限运输车辆行驶公路管理规定》第三条、第十七条规定标准的)
     */
    public static final String DICT_CODE_SNCXSX_3 = "699c6786d0e649fa93e397fdd95a334d";

    /**
     * 事项编码-省内超限1-省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.2米，或者总宽度未超过3米
     * ，或者总长度未超过20米，且车货总质量、轴荷未超过《超限运输车辆行驶公路管理规定》第三条、第十七条规定标准的)
     */
    public static final String DICT_VALUE_SXBM_SNCX1 = "d6b6da5d2db04df193c6c5a5a990ebcd";

    /**
     * 事项编码-省内超限2-省内跨设区的公路超限运输审批(车货总高度从地面算起未超过4.5米，或者总宽度未超过3.75米
     * ，或者总长度未超过28米，或者总质量未超过100000千克的)
     */
    public static final String DICT_VALUE_SXBM_SNCX2 = "9bae07a667a44ed999bd4b56910358a5";

    /**
     * 事项编码-省内超限3-省内跨设区的公路超限运输审批(车货总高度从地面算起超过4.5米，或者总宽度超过3.75米
     * ，或者总长度超过28米，或者总质量超过100000千克的)
     */
    public static final String DICT_VALUE_SXBM_SNCX3 = "7c632e5c55cb4124a56da96467d71378";

    /**
     * 公路超限运输许可_1
     */
    public static final String DICT_VALUE_SXBM_GLCX_1 = "1b0f5aa56d2d44b184d58a322d32bf48";

    /**
     * 公路超限运输许可_2
     */
    public static final String DICT_VALUE_SXBM_GLCX_2 = "558c75fae3204317854947615749748b";

    /**
     * 事项编码-跨省、跨省内设区的市客运经营许可
     */
    public static final String DICT_VALUE_SXBM_DLKYJYXK = "ehf700995c6148acab79fb173e6f9308";

    /**
     * 事项编码-县级行政区域内的客运班线或者毗邻县之间的客运班线许可
     */
    public static final String DICT_VALUE_SXBM_DLKYBXXK_QX = "eif700995c6148acab79fb173e6f9308";

    /**
     * 事项编码-跨省、跨省内设区、跨县级行政区域内（毗邻县之间除外）的市客运班线许可
     */
    public static final String DICT_VALUE_SXBM_DLKYBXXK_SJ = "eef700995c6148acab79fb173e6f9308";

    /**
     * 事项编码-跨省、跨省内设区、跨县级行政区域内（毗邻县之间除外）的市客运车辆变更审批
     */
    public static final String DICT_VALUE_SXBM_DLKYCLBG = "egf700995c6148acab79fb173e6f9308";

    /**
     * 事项编码-跨省、跨省内设区、跨县级行政区域内（毗邻县之间除外）的市班线班次下限、车辆数量及要求、中途停靠站点经营区域变更审批
     */
    public static final String DICT_VALUE_SXBM_DLKYBXBG = "eff700995c6148acab79fb173e6f9308";

    /**
     * 事项编码-网络预约出租汽车驾驶员证许可
     */
    public static final String DICT_VALUE_SXBM_WYCZJSZ = "af4d95bc72e74a9cbd9c94d7d330b08e";

    /**
     * 事项编码-网络预约出租汽车车辆运营许可(市级)
     */
    public static final String DICT_VALUE_SXBM_WYCZYYZ = "cf4f73a1f0f247d6ad5247ed293bb914";

    /**
     * 事项编码-网络预约出租汽车车辆运营许可(县级)
     */
    public static final String DICT_VALUE_SXBM_WYCZYYZ_XIAN = "518c9a05904b43d5bd4c546002eed627";

    /**
     * 实施事项编码-省级权限范围内与航道有关工程航道通航条件影响评价审核
     */
    public static final String DICT_VALUE_SSSXBM_GHSX1 = "9078909303e04c328e04b4f8833e7c5d";

    /**
     * 实施事项编码-《港口设施保安符合证书》年度核验
     */
    public static final String DICT_VALUE_SSSXBM_GHSX2 = "45dc92c11c254e69b4f94774032656b9";

    /**
     * 权限编码-实施事项编辑
     */
    public static final String DICT_VALUE_QXBM_SXBJ = "SSSX_GL_MENU.SSSX_EDIT";

    /**
     * 权限编码-通行能力审批
     */
    public static final String DICT_VALUE_QXBM_TXNLSP = "TXNLSP_MENU.TXNLPLSP";

    /**
     * 权限编码-通行能力路线信息维护
     */
    public static final String DICT_VALUE_QXBM_LXWH = "CXYSTXNLWH_MENU.TXNL_LXWH";

    /**
     * 权限编码-通行能力路线信息维护
     */
    public static final String DICT_VALUE_QXBM_GDWSXG = "WDGD_MENU.GDWSXG";

    /**
     * 审批流程编号-涉路许可
     */
    public static final String DICT_VALUE_SPLC_SLXK = "1265978144704167938";
    ////////////////////////////////////  特定组织机构、人员   ////////////////////////////////

    /**
     * 特定行政区划代码-广德县
     */
    public static final String XZQH_CODE_GUANG_DE = "341822";

    /**
     * 特定行政区划代码-宿松县
     */
    public static final String XZQH_CODE_SU_SONG = "340826";

    /**
     * 特定组织机构-安徽省交通运输厅
     */
    public static final String DICT_VALUE_ORG_SJTT = "A3E3A2810E4E4C1E9ADEA2C09EB03849";

    /**
     * 特定组织机构-安徽省交通运输厅
     */
    public static final String DICT_STRING_ORG_SJTT = "安徽省交通运输厅";

    /**
     * 特定组织机构-安徽省高速路政支队
     */
    public static final String DICT_VALUE_ORG_GSLZZD = "31F6B2E8F2D54D339C94797C31F077E5";

    /**
     * 特定组织机构-安徽省高速路政支队
     */
    public static final String DICT_STRING_ORG_GSLZZD = "安徽省高速路政支队";

    /**
     * 特定人员-安徽省交通运输厅-ID-王磊
     */
    public static final String DICT_VALUE_USER_WL = "1429CFBBEA6F447CA1191D7E25E32CC3";

    /**
     * 特定人员-安徽省交通运输厅-名称-王磊
     */
    public static final String DICT_STRING_USER_WL = "纵波";

    /**
     * 特定人员-安徽省交通运输厅-ID-纵波
     *//*
    public static final String DICT_VALUE_USER_ZB = "1429CFBBEA6F447CA1191D7E25E32CC3";

    *//**
     * 特定人员-安徽省交通运输厅-名称-纵波
     *//*
    public static final String DICT_STRING_USER_ZB = "纵波";*/


    ////////////////////////////////////  大件运输   ////////////////////////////////////
    /**
     * 大件运输办件编号-起运省
     */
    public static final String DICT_VALUE_DJYSBJBM_QYS = "A3400";

    /**
     * 大件运输办件编号-延期
     */
    public static final String DICT_VALUE_DJYSBJBM_YQ = "YQ";

    /**
     * 大件运输办件编号-延期-起运省
     */
    public static final String DICT_VALUE_DJYSBJBM_YQQYS = "YQ3400";

    /**
     * 大件运输-接口返回编码-成功
     */
    public static final String DICT_VALUE_DJYS_JKFHNM_SUC = "0000";

    /**
     * 大件运输-受理结果编码-受理
     */
    public static final String DICT_VALUE_DJYS_SLJGBM_SL = "A01";

    /**
     * 大件运输-受理结果编码-不受理
     */
    public static final String DICT_VALUE_DJYS_SLJGBM_BSL = "A03";

    /**
     * 大件运输-受理结果编码-补齐补正
     */
    public static final String DICT_VALUE_DJYS_SLJGBM_BQBZ = "A02";

    /**
     * 大件运输-联合审查状态-协调路线
     */
    public static final String DICT_VALUE_DJYS_LHSCZT_XTLX = "coordination";

    /**
     * 大件运输-联合审查状态-决定
     */
    public static final String DICT_VALUE_DJYS_LHSCZT_JD = "decision";

    /**
     * 大件运输-联合审查状态-发证
     */
    public static final String DICT_VALUE_DJYS_LHSCZT_FZ = "certification";

    /**
     * 大件运输-联合审查状态-联合审查
     */
    public static final String DICT_VALUE_DJYS_LHSCZT_LHSC = "countersign";

    /**
     * 省内超限运输-通行证撤销
     */
    public static final String DICT_VALUE_SNCX_TXZCX = "licEnd";

    /**
     * 大件运输-受理编码
     */
    public static final String DICT_VALUE_DJYS_SL_OPT_CODE = "Act_3";

    /**
     * 大件运输-受理名称
     */
    public static final String DICT_VALUE_DJYS_SL_OPT_NAME = "受理";

    /**
     * 大件运输-分发编码
     */
    public static final String DICT_VALUE_DJYS_FF_OPT_CODE = "Act_2";

    /**
     * 大件运输-分发名称
     */
    public static final String DICT_VALUE_DJYS_FF_OPT_NAME = "分发";

    /**
     * 大件运输-状态-待受理
     */
    public static final String DICT_VALUE_DJYS_ZT_DSL = "10";

    /**
     * 大件运输-状态-联合审查
     */
    public static final String DICT_VALUE_DJYS_ZT_LHSC = "41";

    /**
     * 大件运输-状态-已发证
     */
    public static final String DICT_VALUE_DJYS_ZT_YFZ = "52";

    /**
     * 大件运输-状态-不予受理
     */
    public static final String DICT_VALUE_DJYS_ZT_BYSL = "90";

    /**
     * 大件运输-状态-不予许可
     */
    public static final String DICT_VALUE_DJYS_ZT_CX91 = "91";

    /**
     * 大件运输-状态-撤销编码92
     */
    public static final String DICT_VALUE_DJYS_ZT_CX92 = "92";

    /**
     * 大件运输-状态-撤销编码93
     */
    public static final String DICT_VALUE_DJYS_ZT_CX93 = "93";

    // 大件运输-受理意见-受理
    public static final String DICT_VALUE_DJYS_SLJGYJ_SL = "材料齐全且符合符合法定条件，同意受理";

    // 大件运输-审批意见-不同意
    public static final String DICT_VALUE_DJYS_SPJGYJ_BTY = "不同意";

    // 大件运输-审批意见-同意
    public static final String DICT_VALUE_DJYS_SPJGYJ_TY = "道路通行条件允许情况下保证安全谨慎驾驶，夜间、恶劣气候、节假日禁行。";

    // 部中心系统 	 系统代码 （获取数据的接口必要参数）
    public static final String SYSCODE_OF_DEPT_CENTER_SYSTEM = "3400";

    // 部中心系统	安徽省行政区化代码
    public static final String XING_ZHENG_QU_HUA_CODE_OF_AN_HUI = "340000";

    // 部中心系统  	安全证书 （获取数据的接口必要参数）
    public static final String AUTHCERT_OF_DEPT_CENTER_SYSTEM = "402028";

    /**
     * 部中心系统 	 系统代码 （获取数据的接口必要参数）
     */
    public static final String SYSCODE_OF_DEPT_CENTER_SYSTEM_SYSCODE = "3400";
    /**
     * 部中心系统 	 系统代码 （获取数据的接口必要参数）
     */
    public static final String SYSCODE_OF_DEPT_CENTER_SYSTEM_AUTHCERT = "402028";
    /**
     * 部中心系统 	 系统代码 （获取数据的接口必要参数）
     */
    public static final String SYSCODE_OF_DEPT_CENTER_SYSTEM_DISCODE = "340000";

    /**
     * 部中心系统	安徽省机构标识
     */
    public static final String JI_GOU_BIAN_ZHI_OF_AN_HUI = "1100201511194259BA278C06B8F08052";

    // 部中心系统	从部中心获取到文件数据后保存文件到文件服务器路径（拼接到sysconfig.UPLOAD_PATH=/mnt/share/upload后面）
    public static final String FILE_SAVE_PATH_OF_DEPT_CENTER_SYSTEM = "/deptCenterSystem";

    // 部中心系统  	获取管理机构列表 接口（拼接到SERVER_PATH_OF_DEPT_CENTER_SYSTEM后面）getMstOrg
    public static final String INTERFACE_OF_GET_MST_ORG_LIST = "/zcedi/mst/org/list.edi";

    //部中心系统  	获取管理机构信息 接口
    public static final String INTERFACE_OF_GET_MST_ORG = "/zcedi/mst/org/get.edi";

    // 部中心系统  	获取当前系统时间
    public static final String INTERFACE_OF_GET_SYS_TIME = "/zcedi/sys/time.edi";

    // 部中心系统  	获取当前系统时间
    public static final String INTERFACE_OF_GET_SYS_TIME_NEW = "/licedi/sys/time.edi";

    // 部中心系统 	生成通用数据标识
    public static final String INTERFACE_OF_GET_KEY = "/zcedi/sys/key.edi";

    // 部中心系统 	获取指定文件数据
    public static final String INTERFACE_OF_GET_FILE = "/licedi/sys/file/get.edi";

    // 部中心系统 	 提交文件数据内容
    public static final String INTERFACE_OF_SUB_FILE = "/zcedi/sys/file/submit.edi";

    // 部中心系统   	获取运输企业信息
    public static final String INTERFACE_OF_GET_APPLICANT = "/licedi/applicant/single.edi";

    // 部中心系统	获取运输企业列表
    public static final String INTERFACE_OF_GET_APPLICANT_LIST = "/zclic/lic/applicant/list.edi";

    // 部中心系统	获取许可申请信息
    public static final String INTERFACE_OF_GET_REQUEST = "/licedi/request/get.edi";

    // 部中心系统	获取许可申请状态
    public static final String INTERFACE_OF_GET_REQ_STATUS = "/zclic/lic/request/status.edi";

    // 部中心系统	获取许可申请列表
    public static final String INTERFACE_OF_GET_REQUEST_LIST = "/zclic/lic/request/list.edi";

    // 部中心系统	获取内容变更列表
    public static final String INTERFACE_OF_GET_REQ_CHANGE = "/zclic/lic/change/list.edi";

    // 部中心系统	获得申请许可关联车辆信息接口
    public static final String INTERFACE_OF_GET_VEHICLE = "/licedi/request/vehicles.edi";

    // 部中心系统	 获得申请许可关联的分省方案信息接口
    public static final String INTERFACE_OF_GET_DIST_PLAN = "/zclic/lic/request/getLicDistPlan.edi";

    // 部中心系统	获取处理流程记录
    public static final String INTERFACE_OF_GET_LIC_PROCESS = "/zclic/lic/process/get.edi";

    // 部中心系统	获取处理流程列表
    public static final String INTERFACE_OF_GET_LIC_PROCESS_LIST = "/zclic/lic/process/list.edi";

    // 部中心系统	提交处理流程记录
    public static final String INTERFACE_OF_SUB_LIC_PROCESS = "/zclic/lic/process/submit.edi";

    // 部中心系统	起运地省份提交发证操作结果
    public static final String INTERFACE_OF_SUB_ISSUE = "/licedi/process/issue.edi";

    // 部中心系统	审查岗提交验算开始消息，暂停审批计时
    public static final String INTERFACE_OF_SUB_CHECKS = "/licedi/calculation/starting.edi";

    // 部中心系统	审查岗提交验算结束消息，继续审批计时
    public static final String INTERFACE_OF_SUB_CHECKE = "/licedi/calculation/ending.edi";

    // 部中心系统	 用于根据申请编号获取相关的实时审批状态信息
    public static final String INTERFACE_OF_GET_CURRENT_LINK = "/licedi/request/currentLink.edi";

    // 部中心系统	 用于起运地省份提交受理操作结果
    public static final String ACCEPT = "/licedi/process/accept.edi";

    // 部中心系统	 用于跨省系统省级平台提交审查操作结果;
    public static final String REVIEW = "/licedi/process/review.edi";

    //用于起运地省份提交协调操作结果
    public static final String COORDINATE = "/licedi/process/coordinate.edi";

    // 部中心系统	 用于起运地省份提交许可决定操作结果
    public static final String DECIDE = "/licedi/process/decide.edi";

    // 部中心系统	 用于起运地省份提交发证操作结果
    public static final String ISSUE = "/licedi/process/issue.edi";

    // 部中心系统	 用于起运地省份提交勘验不通过操作结果
    public static final String CHECKFAIL = "/licedi/process/checkFail.edi";

    // 部中心系统	 用于获取车辆变更申请列表
    public static final String CHANGELIST = "/licedi/vehicleChange/list.edi";

    // 部中心系统	用于提交省内申请的处理流程数据
    public static final String CHANGEREVIEW = "/licedi/vehicleChange/review.edi";

    // 部中心系统	用于提各省获取对本省的评价信息
    public static final String INTERFACE_OF_GETHCP = "/licedi/api/v1/appraiseinfo/list.edi";

    // 部中心系统	用于推送大件运输评论核实数据
    public static final String INTERFACE_OF_HCP_VERIFY = "/licedi/api/v1/appraiseinfo/verify.edi";

    // 部中心系统	用于推送大件运输评论提交整改反馈信息
    public static final String INTERFACE_OF_HCP_RECTIFICATION = "/licedi/api/v1/appraiseinfo/rectification.edi";

    /**
     * 部中心系统	 用于获取延期申请列表
     */
    public static final String EXTENSIONLIST = "/licedi/request/extensionList.edi";

    /**
     * 部中心系统	 历史许可数据上传
     */
    public static final String SUBHISTORICAL = "/licpedi/provincialRequest/historical/submit.edi";

    /**
     * 部中心系统	 实时许可数据上传
     */
    public static final String SUBNEWREQUEST = "/licpedi/provincialRequest/newRequest/submit.edi";

    /**
     * 部中心系统	 实时审批记录
     */
    public static final String SUBNEWPROCESS = "/licpedi/provincialRequest/newProcess/submit.edi";

    /**
     * 部中心系统	获取许可申请列表    起运省
     */
    public static final String INTERFACE_OF_GET_QYS_REQUEST_LIST = "/licedi/request/qys.edi";

    /**
     * 部中心系统	获取许可申请列表    沿线省
     */
    public static final String INTERFACE_OF_GET_YXS_REQUEST_LIST = "/licedi/request/yxs.edi";

    /**
     * 部中心系统	 根据许可申请编号获取相关的路线内容信息接口
     */
    public static final String INTERFACE_OF_GET_ROUTE = "/licedi/request/routes.edi";

    /**
     * 部中心系统	获取红牌警告信息
     */
    public static final String INTERFACE_OF_GET_RED = "/licedi/card/red.edi";

    /**
     * 部中心系统	获取黄牌预警信息
     */
    public static final String INTERFACE_OF_GET_YELLOW = "/licedi/card/yellow.edi";

    /**
     * 部中心系统	 部中心时间
     */
    public static final String SYSTIME = "/licedi/sys/time.edi";

    /////////////////////////////////////////  接口地址  ///////////////////////////////////////////

    /**
     * 工商局接口
     */
    @Value("${interfaceUrl.gsjUrl}")
    public String gsjUrl;

    /**
     * 投资项目代码接口
     */
    @Value("${interfaceUrl.tzxmdmUrl}")
    public String tzxmdmUrl;

}
