package com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.service;


import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.FzclVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SqclVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.entity.FjbVO;

import java.io.InputStream;

/****
 * @className CommonService
 * @author flm
 * @description 公共Service接口
 * @version 1.0
 * @date 2020-03-30 10:28
 */
public interface XzspCommonService {

    /******
     * 附件保存
     * @param sqclVo
     * @return
     */
    Boolean saveFileInfo(SqclVo sqclVo);

    /******
     * 辅助附件保存
     * @param fzclVo
     * @returnfz
     */
    Boolean saveFzfileInfo(FzclVo fzclVo);

    /******
     * 批量删除附件
     * @param ids 附件id
     * @return
     */
    boolean fileDeleteByIds(String ids);

    /******
     * 通过附件id查找附件信息
     * @param id 附件id
     * @return
     */
    FjbVO getFjxxByFjid(String id);

    /**
     * 保存申请材料
     * @param sqclVo 申请材料
     * @param stream 文件流
     * @return
     */
    boolean saveSqclFile(SqclVo sqclVo, InputStream stream);

    /**
     * 根据fileKey删除附件
     * @param fileKey
     * @return
     */
    boolean deleteByKey(String fileKey);

    /**
     * 根据fileKey删除辅助附件
     * @param fileKey
     * @return
     */
    boolean deleteFzclByKey(String fileKey);

    /**
     * 根据fileKey删除辅助附件
     * @param fileKey 附件标志
     * @param curUser 当前用户信息
     * @return
     */
    boolean deleteFzclByKey(String fileKey, SysUser curUser);
}
