package com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.service;


import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDzqztp;
import org.apache.ibatis.annotations.Param;

/****
 * @className DocumentService
 * @author flm
 * @description 公共Service接口
 * @version 1.0
 * @date 2020-03-30 10:28
 */
public interface DocumentService {
    /**
     * 根据valueId获得文书数据
     * @param valueId
     * @return
     */
    String getDocumentByValueId(String valueId);

    /**
     * 根据id查询文件路径
     * @param zhuJianId
     * @return
     */
    String findFilePathById(String zhuJianId);

    /**
     * 根据id查询签章信息
     * @param qianZhangId
     * @return
     */
    SysDzqztp searchQianZhangById(String qianZhangId);

    /**
     * 根据电子签章id，删除协同办案签章记录信息（用于系统管理签章更换，同步更新行政审批签章信息）
     * @param qianZhangId 电子签章id
     * @return
     */
    Integer deleteSignatureInfoForXZSP(String qianZhangId);
}
