package com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
* @Description: 附件表实体类
* @Author: flm
* @Date: 2020/4/2
*/
@Data
@TableName("XTBA_J_FJB")
public class FjbVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 附件ID
     */
    @TableId
    private String fjid;

    /**
     * 附件通用id
     */
    private String fjtyid;

    /**
     * 数据来源代码
     */
    private String sjlydm;

    /**
     * 材料名称
     */
    private String clmc;

    /**
     * 保存路径
     */
    private String bclj;

    /**
     * 视频时长
     */
    private Double spsc;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date kssj;

    /**
     * 设备编号
     */
    private String sbbh;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 单位名称
     */
    private String dwmc;

    /**
     * 获取时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date hqsj;
    /**
     * 获取地点
     */
    private String hqdd;
    /**
     * 法律法规ID
     */
    private String flfgid;
    /**
     * 案件证据材料ID
     */
    private String ajzjclid;
    /**
     * 附件类型
     */
    private String fjlx;

    /**
     * fileManager附件key
     */
    private String fileKey;

    @Override
    public String getId() {
        return fjid;
    }

    @Override
    public void setId(String id) {
        this.fjid = id;
    }


}
